/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;

public class RenderReplicaTeleportEntity
extends EntityRenderer<ReplicaTeleportMahoujinEntity> {
    private static final ResourceLocation mahoujin = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_casting.png");

    public RenderReplicaTeleportEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(ReplicaTeleportMahoujinEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(ReplicaTeleportMahoujinEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderReplica(ReplicaTeleportMahoujinEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        matrix.pushPose();
        matrix.translate(x, y, z);
        float[] rgba = entity.getColor();
        float size = entity.getCircleSize() * 2.0f;
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        int lightmapX = 240;
        int lightmapY = 240;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderType type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
        VertexConsumer bb = buffer.getBuffer(type);
        matrix.scale(size, size, size);
        Matrix4f m = matrix.last().pose();
        bb.addVertex(m, -0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, -0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        buffer.endBatch(type);
        matrix.popPose();
    }
}

