/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.networking.Message;
import com.klikli_dev.modonomicon.networking.SyncMultiblockDataMessage;
import com.klikli_dev.modonomicon.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class MultiblockDataManager
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "modonomicon/multiblocks";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final MultiblockDataManager instance = new MultiblockDataManager();
    private Map<ResourceLocation, Multiblock> multiblocks = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private boolean loaded;
    private HolderLookup.Provider registries;

    private MultiblockDataManager() {
        super(GSON, FOLDER);
    }

    public static MultiblockDataManager get() {
        return instance;
    }

    public void registries(HolderLookup.Provider registries) {
        this.registries = registries;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Multiblock getMultiblock(ResourceLocation id) {
        return this.multiblocks.get(id);
    }

    public Map<ResourceLocation, Multiblock> getMultiblocks() {
        return this.multiblocks;
    }

    public Message getSyncMessage() {
        return new SyncMultiblockDataMessage(this.multiblocks);
    }

    public void onDatapackSyncPacket(SyncMultiblockDataMessage message) {
        this.preLoad();
        this.multiblocks = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap(message.multiblocks));
        this.onLoadingComplete();
    }

    public void onDatapackSync(ServerPlayer player) {
        if (player.connection.connection.isMemoryConnection()) {
            return;
        }
        Message syncMessage = this.getSyncMessage();
        Services.NETWORK.sendToSplit(player, syncMessage);
    }

    public void preLoad() {
        this.loaded = false;
        this.multiblocks.clear();
    }

    protected void onLoadingComplete() {
        this.loaded = true;
    }

    protected void apply(Map<ResourceLocation, JsonElement> content, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.preLoad();
        for (Map.Entry<ResourceLocation, JsonElement> entry : content.entrySet()) {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)entry.getValue(), (String)"multiblock json file");
            ResourceLocation type = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)json, (String)"type"));
            Multiblock multiblock = LoaderRegistry.getMultiblockJsonLoader(type).fromJson(json, this.registries);
            multiblock.setId(entry.getKey());
            this.multiblocks.put(multiblock.getId(), multiblock);
        }
        this.onLoadingComplete();
    }
}

