/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.mojang.serialization.Codec;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.packets.magnet.PacketItemInfo;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetMessage;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public abstract class MagnetItem
extends BaseItem {
    public static final DataComponentType<Boolean> ACTIVE = DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build();

    public MagnetItem() {
        super(ItemProperties.create().group((CreativeModeTab)SimpleMagnets.GROUP).maxStackSize(1));
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        MagnetItem.toggleMagnet(player, stack);
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    public static void toggleMagnet(Player player, ItemStack stack) {
        if (!player.level().isClientSide && stack.getItem() instanceof MagnetItem) {
            boolean active = stack.has(ACTIVE) && (Boolean)stack.get(ACTIVE) != false;
            stack.set(ACTIVE, (Object)(!active ? 1 : 0));
            SimpleMagnets.CHANNEL.sendToPlayer(player, (BasePacket)new PacketToggleMagnetMessage(active));
        }
    }

    public void inventoryUpdate(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity.isSpectator()) {
            return;
        }
        if (stack.has(ACTIVE) && ((Boolean)stack.get(ACTIVE)).booleanValue()) {
            AABB area;
            int r;
            if (this.canPickupItems(stack)) {
                r = this.getRangeItems(stack);
                area = new AABB(entity.position().add((double)(-r), (double)(-r), (double)(-r)), entity.position().add((double)r, (double)r, (double)r));
                List items = level.getEntities((EntityTypeTest)EntityType.ITEM, area, item -> !(!item.isAlive() || level.isClientSide && item.tickCount <= 1 || item.thrower != null && item.thrower.equals(entity.getUUID()) && item.hasPickUpDelay() || item.getItem().isEmpty() || item.getPersistentData().contains("PreventRemoteMovement") || !this.canPickupStack(stack, item.getItem())));
                items.forEach(item -> item.setPos(entity.getX(), entity.getY(), entity.getZ()));
                if (!level.isClientSide && entity instanceof Player && CommonUtils.isModLoaded((String)"itemphysic")) {
                    items.forEach(item -> MagnetItem.playerTouch(item, (Player)entity));
                }
            }
            if (!level.isClientSide && this.canPickupXp(stack) && entity instanceof Player) {
                r = this.getRangeXp(stack);
                area = new AABB(entity.position().add((double)(-r), (double)(-r), (double)(-r)), entity.position().add((double)r, (double)r, (double)r));
                Player player = (Player)entity;
                List orbs = level.getEntitiesOfClass(ExperienceOrb.class, area);
                orbs.forEach(orb -> {
                    orb.invulnerableTime = 0;
                    player.takeXpDelay = 0;
                    orb.playerTouch(player);
                });
            }
        }
    }

    private static void playerTouch(ItemEntity itemEntity, Player player) {
        if (!itemEntity.level().isClientSide) {
            if (itemEntity.hasPickUpDelay()) {
                return;
            }
            ItemStack itemstack = itemEntity.getItem();
            Item item = itemstack.getItem();
            int i = itemstack.getCount();
            TriState result = EventHooks.fireItemPickupPre((ItemEntity)itemEntity, (Player)player).canPickup();
            if (result.isFalse()) {
                return;
            }
            ItemStack copy = itemstack.copy();
            if ((result.isTrue() || !itemEntity.hasPickUpDelay() && (itemEntity.getTarget() == null || itemEntity.lifespan - itemEntity.getAge() <= 200 || itemEntity.getTarget().equals(player.getUUID()))) && player.getInventory().add(itemstack)) {
                copy.setCount(copy.getCount() - itemstack.getCount());
                EventHooks.fireItemPickupPost((ItemEntity)itemEntity, (Player)player, (ItemStack)copy);
                player.take((Entity)itemEntity, i);
                if (itemstack.isEmpty()) {
                    itemEntity.discard();
                    itemstack.setCount(i);
                }
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), i);
                player.onItemPickup(itemEntity);
            }
        }
    }

    protected abstract boolean canPickupItems(ItemStack var1);

    protected abstract boolean canPickupStack(ItemStack var1, ItemStack var2);

    protected abstract boolean canPickupXp(ItemStack var1);

    protected abstract int getRangeItems(ItemStack var1);

    protected abstract int getRangeXp(ItemStack var1);

    public boolean isFoil(ItemStack stack) {
        return stack.has(ACTIVE) && (Boolean)stack.get(ACTIVE) != false;
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept(this.getTooltip());
    }

    protected abstract Component getTooltip();

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking e) {
        if (!e.getEntity().level().isClientSide && e.getTarget() instanceof ItemEntity && ((ItemEntity)e.getTarget()).thrower != null) {
            SimpleMagnets.CHANNEL.sendToPlayer(e.getEntity(), (BasePacket)new PacketItemInfo((ItemEntity)e.getTarget()));
        }
    }
}

