/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ShieldControlData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ItemData;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class ShieldControlEntity
extends ModuleEntity<ShieldControlData> {
    public static final Set<ResourceKey<DamageType>> UNBLOCKABLE = Sets.newHashSet((Object[])new ResourceKey[]{DamageTypes.DROWN, DamageTypes.STARVE, DamageTypes.IN_WALL, DamageTypes.GENERIC_KILL});
    public static final HashMap<ResourceKey<DamageType>, Double> ENV_SOURCES = new HashMap();
    private ShieldSaveData data = new ShieldSaveData(0.0, 0.0, 0.0, 0, 0, 0, 0, false);
    private float shieldAnim;
    private float shieldHitIndicator;
    private final int shieldColour;
    private BooleanProperty shieldEnabled = new BooleanProperty("shield_mod.enabled", true).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED);
    private BooleanProperty alwaysVisible = new BooleanProperty("shield_mod.always_visible", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
    private int tick;
    private boolean conflict = false;
    private ShieldData shieldCache;
    private long lastHitTime;
    private double passivePowerCache = 0.0;
    public static final Codec<ShieldControlEntity> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, ShieldControlEntity> STREAM_CODEC;

    public ShieldControlEntity(Module<ShieldControlData> module) {
        super(module);
        this.shieldColour = ShieldControlEntity.getDefaultShieldColour(module.getModuleTechLevel());
    }

    ShieldControlEntity(Module<?> module, int gridX, int gridY, ShieldSaveData data, float shieldAnim, float shieldHitIndicator, BooleanProperty shieldEnabled, BooleanProperty alwaysVisible) {
        super(module, gridX, gridY);
        this.data = data;
        this.shieldAnim = shieldAnim;
        this.shieldHitIndicator = shieldHitIndicator;
        this.shieldColour = ShieldControlEntity.getDefaultShieldColour(module.getModuleTechLevel());
        this.shieldEnabled = shieldEnabled;
        this.alwaysVisible = alwaysVisible;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new ShieldControlEntity(this.module, this.getGridX(), this.getGridY(), new ShieldSaveData(this.data), this.shieldAnim, this.shieldHitIndicator, this.shieldEnabled.copy(), this.alwaysVisible.copy());
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        properties.add(this.shieldEnabled);
        properties.add(this.alwaysVisible);
    }

    @Override
    public void tick(ModuleContext moduleContext) {
        boolean enabled;
        StackModuleContext context;
        IOPStorage storage;
        block25: {
            block24: {
                storage = moduleContext.getOpStorage();
                if (!(moduleContext instanceof StackModuleContext)) break block24;
                context = (StackModuleContext)moduleContext;
                if (EffectiveSide.get().isServer() && storage != null) break block25;
            }
            return;
        }
        if (this.tick++ % 10 == 0) {
            this.clearCaches();
        }
        this.markDirty();
        ShieldData shieldData = this.getShieldData(context.getEntity());
        this.data.shieldCapacity = shieldData.shieldCapacity();
        double chargeRate = shieldData.shieldRecharge();
        boolean bl = enabled = this.shieldEnabled.getValue() && this.getShieldPoints() > 0.0;
        if (this.data.shieldPoints > (double)this.data.shieldCapacity) {
            this.data.shieldPoints = this.data.shieldCapacity;
        }
        if (this.shieldHitIndicator > 0.0f) {
            this.shieldHitIndicator -= 0.1f;
        }
        boolean bl2 = this.data.shieldVisible = enabled && (this.alwaysVisible.getValue() || System.currentTimeMillis() - this.lastHitTime < 5000L);
        if (this.data.shieldVisible && this.shieldAnim < 1.0f) {
            this.shieldAnim = Math.min(this.shieldAnim + 0.05f, 1.0f);
        } else if (!this.data.shieldVisible && this.shieldAnim > 0.0f) {
            this.shieldAnim = Math.max(this.shieldAnim - 0.05f, 0.0f);
        }
        if (this.data.envDmgCoolDown > 0) {
            this.data.envDmgCoolDown = (byte)(this.data.envDmgCoolDown - 1);
        }
        if (!context.isEquipped()) {
            return;
        }
        if (this.conflict) {
            this.data.shieldCapacity = 0;
            this.data.shieldPoints = 0.0;
            return;
        }
        if (enabled && storage.getOPStored() > 0L) {
            double passiveDraw = this.data.shieldPoints * this.data.shieldPoints * EquipCfg.shieldPassiveModifier;
            if (passiveDraw > 0.0) {
                this.passivePowerCache += passiveDraw;
                if (this.passivePowerCache >= 1.0) {
                    storage.modifyEnergyStored((long)(-((int)this.passivePowerCache)));
                    this.passivePowerCache %= 1.0;
                }
            }
        } else if (enabled && this.data.shieldPoints > 0.0) {
            this.data.shieldPoints = Math.max(0.0, this.data.shieldPoints - (double)this.data.shieldCapacity / 1200.0);
        }
        if (this.data.shieldBoost > 0.0) {
            --this.data.boostTime;
            if (this.data.boostTime == 0) {
                this.data.shieldBoost = 0.0;
            }
        }
        if (!enabled) {
            chargeRate *= 1.25;
        }
        if (this.data.shieldCoolDown > 0) {
            this.data.shieldCoolDown = Math.max(0, this.data.shieldCoolDown - (enabled ? 100 : 125));
        } else if (this.data.shieldPoints < (double)this.data.shieldCapacity && this.data.shieldCapacity > 0 && chargeRate > 0.0 && storage.getOPStored() > 0L) {
            double energyPerPoint = Math.max(chargeRate * (double)EquipCfg.energyShieldChg, (double)EquipCfg.energyShieldChg);
            long extracted = storage.modifyEnergyStored((long)(-((int)Math.max(1.0, Math.min(chargeRate, (double)this.data.shieldCapacity - this.data.shieldPoints) * energyPerPoint))));
            this.data.shieldPoints += (double)extracted / energyPerPoint;
        }
    }

    public double getShieldPoints() {
        return this.data.shieldPoints + this.data.shieldBoost;
    }

    public int getShieldCapacity() {
        return this.data.shieldCapacity;
    }

    public double getMaxShieldBoost() {
        return this.data.shieldBoost == 0.0 ? 0.0 : this.data.maxBoost;
    }

    public double getShieldBoost() {
        return this.data.shieldBoost;
    }

    public int getShieldCoolDown() {
        return this.data.shieldCoolDown;
    }

    public int getMaxShieldCoolDown() {
        return ((ShieldControlData)this.module.getData()).coolDownTicks() * 100;
    }

    public void setShieldCoolDown(int shieldCoolDown) {
        this.data.shieldCoolDown = shieldCoolDown;
    }

    public void tryBlockDamage(LivingIncomingDamageEvent event) {
        DamageSource source;
        block6: {
            block5: {
                source = event.getSource();
                if (!this.shieldEnabled.getValue() || source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) break block5;
                if (!FastStream.of(UNBLOCKABLE).anyMatch(arg_0 -> ((DamageSource)source).is(arg_0))) break block6;
            }
            return;
        }
        if (this.blockEnvironmentalDamage(event, source)) {
            return;
        }
        float damage = this.applyDamageModifiers(source, event.getAmount());
        if ((double)damage <= this.getShieldPoints()) {
            LivingEntity entity = event.getEntity();
            event.setCanceled(true);
            this.subtractShieldPoints(damage);
            this.onShieldHit(entity, true);
        }
    }

    private boolean blockEnvironmentalDamage(LivingIncomingDamageEvent event, DamageSource source) {
        double value;
        LivingEntity entity = event.getEntity();
        if (source.is(DamageTypeTags.IS_FIRE) && this.getShieldPoints() > 10.0) {
            entity.clearFire();
        }
        if ((value = ((Double)FastStream.of(ENV_SOURCES.entrySet()).filter(e -> source.is((ResourceKey)e.getKey())).map(Map.Entry::getValue).firstOrDefault((Object)0.0)).doubleValue()) != 0.0 && (value /= 20.0) <= this.getShieldPoints()) {
            this.subtractShieldPoints(value);
            event.setCanceled(true);
            this.lastHitTime = System.currentTimeMillis();
            this.shieldAnim = 1.0f;
            this.shieldHitIndicator = 1.0f;
            this.data.shieldCoolDown = this.getMaxShieldCoolDown();
            if (this.data.envDmgCoolDown == 0) {
                float hitPitch = 0.7f + (float)(Math.min(1.0, this.getShieldPoints() / (((double)this.data.shieldCapacity + this.getMaxShieldBoost()) * 0.1)) * 0.3);
                entity.level().playSound(null, entity.blockPosition(), (SoundEvent)DESounds.SHIELD_STRIKE.get(), SoundSource.PLAYERS, 0.25f, (0.95f + entity.level().random.nextFloat() * 0.1f) * hitPitch);
                this.data.envDmgCoolDown = (byte)40;
            }
            this.markDirty();
            return true;
        }
        return false;
    }

    public void tryBlockDamage(LivingDamageEvent.Pre event) {
        DamageSource source = event.getSource();
        if (!this.shieldEnabled.getValue() || UNBLOCKABLE.contains(source)) {
            return;
        }
        float damage = this.applyDamageModifiers(source, event.getNewDamage());
        LivingEntity entity = event.getEntity();
        if ((double)damage <= this.getShieldPoints()) {
            event.setNewDamage(0.0f);
            this.subtractShieldPoints(damage);
            this.onShieldHit(entity, true);
        } else if (this.getShieldPoints() > 0.0) {
            damage = (float)((double)damage - this.getShieldPoints());
            event.setNewDamage(damage);
            this.onShieldHit(entity, false);
            this.data.shieldPoints = 0.0;
            this.data.shieldBoost = 0.0;
        }
        this.markDirty();
    }

    private void onShieldHit(LivingEntity entity, boolean damageBlocked) {
        this.lastHitTime = System.currentTimeMillis();
        this.shieldAnim = 1.0f;
        this.shieldHitIndicator = 1.0f;
        if (damageBlocked && (double)this.data.shieldCapacity + this.getMaxShieldBoost() > 0.0) {
            this.data.shieldCoolDown = this.getMaxShieldCoolDown();
            float hitPitch = 0.7f + (float)(Math.min(1.0, this.getShieldPoints() / (((double)this.data.shieldCapacity + this.getMaxShieldBoost()) * 0.1)) * 0.3);
            entity.level().playSound(null, entity.blockPosition(), (SoundEvent)DESounds.SHIELD_STRIKE.get(), SoundSource.PLAYERS, 1.0f, (0.95f + entity.level().random.nextFloat() * 0.1f) * hitPitch);
        }
        this.markDirty();
    }

    private ShieldData getShieldData(LivingEntity entity) {
        if (this.shieldCache == null) {
            this.conflict = false;
            if (entity == null) {
                this.shieldCache = this.host.getModuleData(ModuleTypes.SHIELD_BOOST, new ShieldData(0, 0.0));
            } else {
                this.shieldCache = ModuleHelper.getCombinedEquippedData(entity, ModuleTypes.SHIELD_BOOST, new ShieldData(0, 0.0));
                this.conflict = ModuleHelper.getEquippedModules(entity, ModuleTypes.SHIELD_CONTROLLER).size() > 1;
            }
            this.markDirty();
        }
        return this.shieldCache;
    }

    private float applyDamageModifiers(DamageSource source, float damage) {
        if (source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            damage *= 3.0f;
        }
        if (source.is(DamageTypes.MAGIC)) {
            damage *= 2.0f;
        }
        return damage;
    }

    public void boost(float shieldBoost, int boostTime) {
        this.data.shieldBoost += (double)shieldBoost;
        this.data.boostTime = Math.max(this.data.boostTime, boostTime);
        this.data.maxBoost = this.data.shieldBoost;
        this.markDirty();
    }

    public void subtractShieldPoints(double points) {
        if (points > 0.0) {
            if (this.data.shieldBoost > 0.0) {
                double number = Math.min(this.data.shieldBoost, points);
                this.data.shieldBoost -= number;
                points -= number;
            }
            this.data.shieldPoints = Math.max(0.0, this.data.shieldPoints - points);
            this.markDirty();
        }
    }

    public int getShieldColour() {
        return this.shieldEnabled.getValue() || this.shieldAnim > 0.0f ? this.shieldColour | (int)((double)(63.0f + 192.0f * this.shieldHitIndicator) * Math.min(1.0, this.getShieldPoints() / ((double)this.data.shieldCapacity * 0.1))) << 24 : 0xFFFFFF;
    }

    public boolean isShieldEnabled() {
        return this.shieldEnabled.getValue();
    }

    public float getShieldState() {
        return this.shieldAnim;
    }

    private static int getDefaultShieldColour(TechLevel techLevel) {
        return switch (techLevel) {
            default -> throw new MatchException(null, null);
            case TechLevel.DRACONIUM -> 32972;
            case TechLevel.WYVERN -> 9175205;
            case TechLevel.DRACONIC -> 0xFF9000;
            case TechLevel.CHAOTIC -> 12520460;
        };
    }

    @Override
    public void clearCaches() {
        this.shieldCache = null;
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        stack.set(ItemData.SHIELD_MODULE_CAP, (Object)this.data.shieldCapacity);
        stack.set(ItemData.SHIELD_MODULE_POINTS, (Object)this.data.shieldPoints);
        stack.set(ItemData.SHIELD_MODULE_COOLDWN, (Object)this.data.shieldCoolDown);
        stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)this.shieldEnabled.copy());
        stack.set(ItemData.BOOL_ITEM_PROP_2, (Object)this.alwaysVisible.copy());
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.data.shieldCapacity = (Integer)stack.getOrDefault(ItemData.SHIELD_MODULE_CAP, (Object)0);
        this.data.shieldPoints = (Double)stack.getOrDefault(ItemData.SHIELD_MODULE_POINTS, (Object)0.0);
        this.data.shieldCoolDown = (Integer)stack.getOrDefault(ItemData.SHIELD_MODULE_COOLDWN, (Object)0);
        this.shieldEnabled = (BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_1, (Object)this.shieldEnabled.copy());
        this.alwaysVisible = (BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_2, (Object)this.alwaysVisible.copy());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ShieldControlEntity)) {
            return false;
        }
        ShieldControlEntity that = (ShieldControlEntity)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.data, that.data) && Objects.equals(this.shieldEnabled, that.shieldEnabled) && Objects.equals(this.alwaysVisible, that.alwaysVisible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data, this.shieldEnabled, this.alwaysVisible);
    }

    static {
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.IN_FIRE, 1.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.ON_FIRE, 0.5);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.LAVA, 4.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.HOT_FLOOR, 1.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.IN_WALL, 1.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.CRAMMING, 0.0);
        ENV_SOURCES.put((ResourceKey<DamageType>)DamageTypes.CACTUS, 1.0);
        CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)ShieldSaveData.CODEC.fieldOf("data").forGetter(e -> e.data), (App)Codec.FLOAT.fieldOf("shield_anim").forGetter(e -> Float.valueOf(e.shieldAnim)), (App)Codec.FLOAT.fieldOf("shield_hit_indicator").forGetter(e -> Float.valueOf(e.shieldHitIndicator)), (App)BooleanProperty.CODEC.fieldOf("shield_enabled").forGetter(e -> e.shieldEnabled), (App)BooleanProperty.CODEC.fieldOf("always_visible").forGetter(e -> e.alwaysVisible)).apply((Applicative)builder, ShieldControlEntity::new));
        STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, ShieldSaveData.STREAM_CODEC, e -> e.data, (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.shieldAnim), (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.shieldHitIndicator), BooleanProperty.STREAM_CODEC, e -> e.shieldEnabled, BooleanProperty.STREAM_CODEC, e -> e.alwaysVisible, ShieldControlEntity::new);
    }

    private static class ShieldSaveData {
        public double shieldPoints;
        public double shieldBoost;
        public double maxBoost;
        public int boostTime;
        public int shieldCapacity;
        public int shieldCoolDown;
        public byte envDmgCoolDown;
        public boolean shieldVisible;
        public static final Codec<ShieldSaveData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("shield_points").forGetter(e -> e.shieldPoints), (App)Codec.DOUBLE.fieldOf("shield_boost").forGetter(e -> e.shieldBoost), (App)Codec.DOUBLE.fieldOf("max_boost").forGetter(e -> e.maxBoost), (App)Codec.INT.fieldOf("boost_time").forGetter(e -> e.boostTime), (App)Codec.INT.fieldOf("shield_capacity").forGetter(e -> e.shieldCapacity), (App)Codec.INT.fieldOf("shield_cool_down").forGetter(e -> e.shieldCoolDown), (App)Codec.BYTE.fieldOf("env_dmg_cool_down").forGetter(e -> e.envDmgCoolDown), (App)Codec.BOOL.fieldOf("shield_visible").forGetter(e -> e.shieldVisible)).apply((Applicative)builder, ShieldSaveData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShieldSaveData> STREAM_CODEC = BCStreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, e -> e.shieldPoints, (StreamCodec)ByteBufCodecs.DOUBLE, e -> e.shieldBoost, (StreamCodec)ByteBufCodecs.DOUBLE, e -> e.maxBoost, (StreamCodec)ByteBufCodecs.INT, e -> e.boostTime, (StreamCodec)ByteBufCodecs.INT, e -> e.shieldCapacity, (StreamCodec)ByteBufCodecs.INT, e -> e.shieldCoolDown, (StreamCodec)ByteBufCodecs.BYTE, e -> e.envDmgCoolDown, (StreamCodec)ByteBufCodecs.BOOL, e -> e.shieldVisible, ShieldSaveData::new);

        public ShieldSaveData(double shieldPoints, double shieldBoost, double maxBoost, int boostTime, int shieldCapacity, int shieldCoolDown, byte envDmgCoolDown, boolean shieldVisible) {
            this.shieldPoints = shieldPoints;
            this.shieldBoost = shieldBoost;
            this.maxBoost = maxBoost;
            this.boostTime = boostTime;
            this.shieldCapacity = shieldCapacity;
            this.shieldCoolDown = shieldCoolDown;
            this.envDmgCoolDown = envDmgCoolDown;
            this.shieldVisible = shieldVisible;
        }

        public ShieldSaveData(ShieldSaveData copyFrom) {
            this.shieldPoints = copyFrom.shieldPoints;
            this.shieldBoost = copyFrom.shieldBoost;
            this.maxBoost = copyFrom.maxBoost;
            this.boostTime = copyFrom.boostTime;
            this.shieldCapacity = copyFrom.shieldCapacity;
            this.shieldCoolDown = copyFrom.shieldCoolDown;
            this.envDmgCoolDown = copyFrom.envDmgCoolDown;
            this.shieldVisible = copyFrom.shieldVisible;
        }
    }
}

