/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.handlers.DESounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class ReactorSound
extends SimpleSoundInstance
implements TickableSoundInstance {
    public boolean donePlaying = false;
    private TileReactorCore tile;
    private float targetPitch;
    private float targetVolume;
    private int stopTimer = 0;

    public ReactorSound(TileReactorCore tile) {
        super((SoundEvent)DESounds.CORE_SOUND.get(), SoundSource.BLOCKS, tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE ? 10.0f : 1.5f, 1.0f, tile.getLevel().random, tile.getBlockPos());
        this.tile = tile;
        this.looping = true;
        this.targetPitch = 1.0f;
    }

    public boolean isStopped() {
        return this.donePlaying;
    }

    public void tick() {
        block13: {
            block12: {
                if (this.tile.roller != null) {
                    this.x = (float)this.tile.roller.pos.x;
                    this.y = (float)this.tile.roller.pos.y;
                    this.z = (float)this.tile.roller.pos.z;
                } else {
                    this.x = (float)this.tile.getBlockPos().getX() + 0.5f;
                    this.y = (float)this.tile.getBlockPos().getY() + 0.5f;
                    this.z = (float)this.tile.getBlockPos().getZ() + 0.5f;
                }
                this.pitch = (float)MathHelper.approachExp((double)this.pitch, (double)this.targetPitch, (double)0.05);
                if (this.tile.reactorState.get() == TileReactorCore.ReactorState.WARMING_UP || this.tile.reactorState.get() == TileReactorCore.ReactorState.STOPPING || this.tile.reactorState.get() == TileReactorCore.ReactorState.COOLING) {
                    this.targetPitch = 0.5f + this.tile.shieldAnimationState / 2.0f;
                } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.RUNNING) {
                    this.targetPitch = 1.0f + (float)Math.max(0.0, Math.min(0.5, 1.0 - this.tile.shieldCharge.get() / this.tile.maxShieldCharge.get() * 10.0));
                } else if (this.tile.reactorState.get() == TileReactorCore.ReactorState.BEYOND_HOPE) {
                    if (this.volume == 1.5f) {
                        this.donePlaying = true;
                    }
                    if (this.tile.getLevel().random.nextInt(10) == 0) {
                        this.targetPitch = 1.0f + this.tile.getLevel().random.nextFloat() / 2.0f;
                    }
                }
                LocalPlayer player = Minecraft.getInstance().player;
                if (this.tile.isRemoved() || player == null) break block12;
                double d = player.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)this.tile.getBlockPos()));
                int n = this.volume > 1.5f ? 4096 : 512;
                if (!(d > (double)n)) break block13;
            }
            this.donePlaying = true;
            this.looping = false;
        }
    }
}

