/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.client.CustomBossInfoHandler;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.ExplosionFX;
import com.brandon3055.draconicevolution.client.render.hud.ShieldHudElement;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.brandon3055.draconicevolution.init.DEClient;
import com.brandon3055.draconicevolution.items.equipment.damage.DefaultStaffDmgMod;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc) {
        switch (packet.getType()) {
            case 1: {
                CrystalUpdateBatcher.handleBatchedData((MCDataInput)packet);
                break;
            }
            case 3: {
                ClientPacketHandler.handleExplosionEffect(mc, packet.readPos(), packet.readVarInt(), packet.readBoolean());
                break;
            }
            case 4: {
                ClientPacketHandler.handleImpactEffect(mc, packet.readPos(), packet.readByte());
                break;
            }
            case 5: {
                ClientPacketHandler.handleUndyingActivation(mc, packet.readVarInt(), (Item)packet.readRegistryId());
                break;
            }
            case 6: {
                ClientPacketHandler.handleBlinkEffect(mc, packet.readVarInt(), packet.readFloat());
                break;
            }
            case 7: {
                ClientPacketHandler.handleStaffEffect(mc, (MCDataInput)packet);
                break;
            }
            case 8: {
                ClientPacketHandler.handleGuardianBeam(mc, (MCDataInput)packet);
                break;
            }
            case 9: {
                ClientPacketHandler.handleGuardianPacket(mc, (MCDataInput)packet);
                break;
            }
            case 10: {
                CustomBossInfoHandler.handlePacket((MCDataInput)packet);
                break;
            }
            case 11: {
                this.handleDislocatorTeleported(mc);
                break;
            }
            case 12: {
                this.handleChunkRelight(mc, packet.readInt(), packet.readInt());
            }
        }
    }

    public static void handleExplosionEffect(Minecraft mc, BlockPos pos, int radius, boolean reload) {
        if (reload) {
            mc.levelRenderer.allChanged();
        }
        if (radius == 0) {
            return;
        }
        ExplosionFX explosionFX = new ExplosionFX((ClientLevel)BrandonsCore.proxy.getClientWorld(), Vector3.fromBlockPosCenter((BlockPos)pos), radius);
        mc.particleEngine.add((Particle)explosionFX);
    }

    public static void handleImpactEffect(Minecraft mc, BlockPos pos, int type) {
        if (mc.level == null) {
            return;
        }
        if (type == 0) {
            int size = 4;
            double speed = 1.0;
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double d3 = (double)j + (mc.level.random.nextDouble() - mc.level.random.nextDouble()) * 0.5;
                        double d4 = (double)i + (mc.level.random.nextDouble() - mc.level.random.nextDouble()) * 0.5;
                        double d5 = (double)k + (mc.level.random.nextDouble() - mc.level.random.nextDouble()) * 0.5;
                        double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5) / speed + mc.level.random.nextGaussian() * 6.0;
                        ClientPacketHandler.createParticle(mc, x, y, z, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2 - 1;
                    }
                }
            }
            mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void createParticle(Minecraft mc, double x, double y, double z, double motionX, double motionY, double motionZ) {
        mc.particleEngine.createParticle((ParticleOptions)DEParticles.GUARDIAN_PROJECTILE.get(), x, y, z, motionX, motionY, motionZ);
    }

    private static void handleUndyingActivation(Minecraft mc, int id, Item item) {
        if (mc.level == null) {
            return;
        }
        Entity entity = mc.level.getEntity(id);
        if (entity != null) {
            mc.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
            if (entity == mc.player) {
                ((ShieldHudElement)((Object)DEClient.SHIELD_HUD.get())).popTotem();
            }
        }
    }

    private static void handleBlinkEffect(Minecraft mc, int id, float distance) {
        Entity entity;
        if (mc.level == null || (entity = mc.level.getEntity(id)) == null) {
            return;
        }
        Vec3 vec = entity.getLookAngle();
        Vec3 pos = entity.getEyePosition(1.0f);
        for (int i = 0; i < 100; ++i) {
            float offset = mc.level.random.nextFloat();
            float speed = (1.0f - offset) * distance;
            speed *= speed;
            Vec3 spawnPos = pos.add(vec.multiply((double)(speed * 10.0f), (double)(speed * 10.0f), (double)(speed * 10.0f)));
            double x = spawnPos.x + (mc.level.random.nextGaussian() - 0.5) * (double)offset;
            double y = spawnPos.y + (mc.level.random.nextGaussian() - 0.5) * (double)offset;
            double z = spawnPos.z + (mc.level.random.nextGaussian() - 0.5) * (double)offset;
            mc.level.addParticle((ParticleOptions)DEParticles.BLINK.get(), x, y, z, vec.x * (double)speed, vec.y * (double)speed, vec.z * (double)speed);
        }
    }

    private static void handleStaffEffect(Minecraft mc, MCDataInput data) {
        Entity entity;
        byte type = data.readByte();
        int entityID = data.readVarInt();
        if (mc.level != null && (entity = mc.level.getEntity(entityID)) instanceof LivingEntity) {
            switch (type) {
                case 0: {
                    DefaultStaffDmgMod.handleEffect((LivingEntity)entity, data);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private static void handleGuardianBeam(Minecraft mc, MCDataInput data) {
        Vector3 source = data.readVector();
        Vector3 target = data.readVector();
        float power = data.readFloat();
        double dist = MathUtils.distance((Vector3)source, (Vector3)target);
        if (mc.level == null) {
            return;
        }
        for (double d = 0.0; d < dist; d += 2.0) {
            Vector3 pos = MathUtils.interpolateVec3((Vector3)source, (Vector3)target, (double)((d - 1.0 + mc.level.random.nextDouble() * 2.0) / dist));
            mc.level.addParticle((ParticleOptions)DEParticles.GUARDIAN_BEAM.get(), true, pos.x, pos.y, pos.z, (double)power, 0.0, 0.0);
        }
    }

    private static void handleGuardianPacket(Minecraft mc, MCDataInput data) {
        if (mc.level == null) {
            return;
        }
        Entity e = mc.level.getEntity(data.readInt());
        if (!(e instanceof DraconicGuardianEntity)) {
            return;
        }
        DraconicGuardianEntity guardian = (DraconicGuardianEntity)e;
        byte phaseID = data.readByte();
        PhaseManager phaseManager = guardian.getPhaseManager();
        IPhase phase = phaseManager.getCurrentPhase();
        if (phase.getType().getId() != phaseID) {
            return;
        }
        byte function = data.readByte();
        phase.handlePacket(data, function);
    }

    private void handleDislocatorTeleported(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-1, -1, -1), (BlockPos)playerPos.offset(1, 1, 1))) {
            BlockEntity tile = player.level().getBlockEntity(pos);
            if (!(tile instanceof TilePortal)) continue;
            ((TilePortal)tile).clientArrived((Player)player);
        }
    }

    private void handleChunkRelight(Minecraft mc, int chunkX, int chunkZ) {
        if (mc.level == null) {
            return;
        }
        LevelChunk chunk = mc.level.getChunk(chunkX, chunkZ);
        if (chunk != null) {
            // empty if block
        }
    }
}

