/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.EntityFaceConfig;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftblibrary.config.ResourceConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectEntityFaceScreen;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectImageResourceScreen;
import dev.ftb.mods.ftblibrary.config.ui.resource.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.icon.EntityIconLoader;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.item.CustomIconItem;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.registry.ModItems;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ConfigIconItemStack
extends ItemStackConfig {
    public ConfigIconItemStack() {
        super(false, true);
    }

    public void onClicked(Widget clickedWidget, MouseButton button, ConfigCallback callback) {
        if (this.getCanEdit()) {
            if (BaseScreen.isShiftKeyDown()) {
                new SelectItemStackScreen((ItemStackConfig)this, callback).openGui();
            } else if (BaseScreen.isCtrlKeyDown()) {
                this.openImageSelector(callback);
            } else if (ScreenWrapper.hasAltDown()) {
                this.openEntitySelector(callback);
            } else {
                clickedWidget.getGui().openContextMenu(this.makeMenu(callback));
            }
        }
    }

    private void openImageSelector(ConfigCallback callback) {
        ImageResourceConfig imageConfig = new ImageResourceConfig();
        FTBQuests.getComponent(this.getValue(), ModDataComponents.CUSTOM_ICON).ifPresent(arg_0 -> ((ImageResourceConfig)imageConfig).setCurrentValue(arg_0));
        new SelectImageResourceScreen((ResourceConfigValue)imageConfig, accepted -> {
            if (accepted) {
                if (!((ResourceLocation)imageConfig.getValue()).equals((Object)ImageResourceConfig.NONE)) {
                    this.setCurrentValue((ItemStack)Util.make((Object)new ItemStack((ItemLike)ModItems.CUSTOM_ICON.get()), s -> CustomIconItem.setIcon(s, (ResourceLocation)imageConfig.getValue())));
                } else {
                    this.setCurrentValue(ItemStack.EMPTY);
                }
            }
            callback.save(accepted);
        }).openGui();
    }

    private void openEntitySelector(ConfigCallback callback) {
        EntityFaceConfig faceConfig = new EntityFaceConfig();
        FTBQuests.getComponent(this.getValue(), ModDataComponents.ENTITY_FACE_ICON).ifPresent(rl -> faceConfig.setCurrentValue((Object)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(rl))));
        new SelectEntityFaceScreen((ResourceConfigValue)faceConfig, accepted -> {
            if (accepted) {
                if (!((EntityType)faceConfig.getValue()).equals(EntityFaceConfig.NONE)) {
                    this.setCurrentValue((ItemStack)Util.make((Object)new ItemStack((ItemLike)ModItems.CUSTOM_ICON.get()), s -> CustomIconItem.setFaceIcon(s, (EntityType)faceConfig.getValue())));
                } else {
                    this.setCurrentValue(ItemStack.EMPTY);
                }
            }
            callback.save(accepted);
        }).openGui();
    }

    private List<ContextMenuItem> makeMenu(ConfigCallback callback) {
        return List.of(new ContextMenuItem((Component)Component.literal((String)"Item Icon"), ItemIcon.getItemIcon((Item)Items.DIAMOND), b -> new SelectItemStackScreen((ItemStackConfig)this, callback).openGui()), new ContextMenuItem((Component)Component.literal((String)"Image Icon"), Icons.ART, b -> this.openImageSelector(callback)), new ContextMenuItem((Component)Component.literal((String)"Entity Face Icon"), EntityIconLoader.getIcon((EntityType)EntityType.PIG), b -> this.openEntitySelector(callback)));
    }
}

