/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class XPTask
extends Task
implements ISingleLongValueTask {
    private long value = 1L;
    private boolean points = false;

    public XPTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.XP;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String formatMaxProgress() {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)this.value) : this.value);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)progress) : progress);
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putLong("value", this.value);
        nbt.putBoolean("points", this.points);
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.value = nbt.getLong("value");
        this.points = nbt.getBoolean("points");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarLong(this.value);
        buffer.writeBoolean(this.points);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.value = buffer.readVarLong();
        this.points = buffer.readBoolean();
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addBool("points", this.points, v -> {
            this.points = v;
        }, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.reward.ftbquests.xp_levels").append(": ").append((Component)Component.literal((String)this.formatMaxProgress()).withStyle(ChatFormatting.RED));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)XPTask.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.totalExperience = experience = XPTask.getPlayerXP(player) + amount;
        player.experienceLevel = XPTask.getLevelForExperience(experience);
        int expForLevel = XPTask.getExperienceForLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return XPTask.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + XPTask.sum(level - 15, 37, 5);
        }
        return 1395 + XPTask.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = XPTask.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (!this.checkTaskSequence(teamData)) {
            return;
        }
        int add = (int)Math.min(this.points ? (long)XPTask.getPlayerXP((Player)player) : (long)player.experienceLevel, Math.min(this.value - teamData.getProgress(this), Integer.MAX_VALUE));
        if (add <= 0) {
            return;
        }
        if (this.points) {
            XPTask.addPlayerXP((Player)player, -add);
            player.giveExperienceLevels(0);
        } else {
            player.giveExperienceLevels(-add);
        }
        teamData.addProgress(this, add);
    }
}

