/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class FoxTailModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private PlayerModel<AbstractClientPlayer> playerModel;
    private ModelPart tail;
    private ModelPart ear1;
    private ModelPart ear2;

    public FoxTailModel(PlayerModel<AbstractClientPlayer> playerModel, LayerDefinition definition) {
        this.playerModel = playerModel;
        ModelPart root = definition.bakeRoot();
        this.ear1 = root.getChild("right_ear");
        this.ear2 = root.getChild("left_ear");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        root.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(8, 1).addBox(-4.0f, -10.0f, -4.0f, 2.0f, 2.0f, 1.0f), PartPose.ZERO);
        root.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(15, 1).addBox(2.0f, -10.0f, -4.0f, 2.0f, 2.0f, 1.0f), PartPose.ZERO);
        root.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(30, 0).addBox(0.0f, 0.0f, 0.0f, 4.0f, 9.0f, 5.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.ear1, (Object)this.ear2);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.tail);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ear1.copyFrom(this.playerModel.head);
        this.ear2.copyFrom(this.playerModel.head);
        if (ageInTicks % 60.0f < 2.0f) {
            this.ear1.yRot += 0.05f;
            this.ear2.yRot -= 0.05f;
        }
        float delta = Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        if (entityIn.isCrouching()) {
            this.tail.setPos(-2.0f, 14.0f, 5.5f);
            this.tail.xRot = 1.25f + delta;
        } else {
            this.tail.setPos(-2.0f, 10.0f, 0.5f);
            this.tail.xRot = 0.85f + delta;
        }
    }
}

