/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.customization.CustomizationClient;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.builder.BuilderModePreview;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.ConvertScreen;
import snownee.kiwi.customization.network.CApplyBuilderRulePacket;
import snownee.kiwi.customization.network.CConvertItemPacket;
import snownee.kiwi.network.KPacketSender;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.KHolder;

public class BuildersButton {
    private static final BuilderModePreview PREVIEW_RENDERER = new BuilderModePreview();
    private static boolean builderMode;

    public static BuilderModePreview getPreviewRenderer() {
        return PREVIEW_RENDERER;
    }

    public static boolean isBuilderModeOn() {
        if (builderMode && CustomizationClient.buildersButtonKey != null && CustomizationClient.buildersButtonKey.isUnbound()) {
            builderMode = false;
        }
        return builderMode;
    }

    public static boolean onLongPress() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator()) {
            return false;
        }
        builderMode = !builderMode;
        RandomSource random = RandomSource.create();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.EXPERIENCE_ORB_PICKUP, (float)((random.nextFloat() - random.nextFloat()) * 0.35f + 0.9f)));
        return true;
    }

    public static boolean onDoublePress() {
        return false;
    }

    public static boolean onShortPress() {
        AbstractContainerScreen containerScreen;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        Screen screen = mc.screen;
        if (screen instanceof ConvertScreen) {
            screen.onClose();
            return true;
        }
        if (KiwiCommonConfig.kSwitchCreativeOnly && !player.isCreative()) {
            return false;
        }
        if (screen instanceof AbstractContainerScreen && (containerScreen = (AbstractContainerScreen)screen).getMenu().getCarried().isEmpty()) {
            Slot slot = ClientProxy.getSlotUnderMouse(containerScreen);
            if (slot == null || !slot.hasItem() || !slot.allowModification((Player)player)) {
                return false;
            }
            if (screen instanceof CreativeModeInventoryScreen && slot.container != player.getInventory()) {
                return false;
            }
            List<CConvertItemPacket.Group> groups = BuildersButton.findConvertGroups((Player)player, slot.getItem());
            if (groups.isEmpty()) {
                return false;
            }
            ClientProxy.pushScreen(mc, new ConvertScreen(screen, slot, slot.index, groups));
            return true;
        }
        if (screen != null) {
            return false;
        }
        List<CConvertItemPacket.Group> groups = BuildersButton.findConvertGroups((Player)player, player.getMainHandItem());
        if (!groups.isEmpty()) {
            mc.setScreen((Screen)new ConvertScreen(null, null, player.getInventory().selected, groups));
            return true;
        }
        groups = BuildersButton.findConvertGroups((Player)player, player.getOffhandItem());
        if (!groups.isEmpty()) {
            mc.setScreen((Screen)new ConvertScreen(null, null, 40, groups));
            return true;
        }
        return false;
    }

    public static List<CConvertItemPacket.Group> findConvertGroups(Player player, ItemStack itemStack) {
        List<KHolder<BlockFamily>> families = BlockFamilies.findQuickSwitch(itemStack.getItem(), player.isCreative());
        if (families.isEmpty()) {
            return List.of();
        }
        ArrayList groups = Lists.newArrayListWithExpectedSize((int)families.size());
        HashSet addedItems = Sets.newHashSet();
        float ratio = BlockFamilies.getConvertRatio(itemStack.getItem());
        for (KHolder<BlockFamily> family : families) {
            CConvertItemPacket.Group group2 = new CConvertItemPacket.Group();
            boolean cascading = family.value().switchAttrs().cascading();
            List<CConvertItemPacket.Entry> unresolved = cascading ? Lists.newLinkedList() : List.of();
            HashSet iteratedFamilies = cascading ? Sets.newHashSet((Object[])new BlockFamily[]{family.value()}) : Set.of();
            Set<Item> iteratedItems = cascading ? Sets.newHashSet() : Set.of();
            for (Item item : family.value().items().toList()) {
                float convertRatio = BlockFamilies.getConvertRatio(item);
                CConvertItemPacket.Entry entry2 = new CConvertItemPacket.Entry(ratio / convertRatio);
                Pair pair = Pair.of((Object)family.key(), (Object)item);
                entry2.steps().add((Pair<ResourceLocation, Item>)pair);
                if (cascading) {
                    unresolved.add(entry2);
                    iteratedItems.add(item);
                }
                if (!addedItems.contains(item)) {
                    group2.entries().add(entry2);
                }
                addedItems.add(item);
            }
            while (!unresolved.isEmpty()) {
                CConvertItemPacket.Entry parentEntry = (CConvertItemPacket.Entry)unresolved.removeFirst();
                Pair<ResourceLocation, Item> lastStep = parentEntry.steps().getLast();
                Item lastItem = (Item)lastStep.getSecond();
                ratio = BlockFamilies.getConvertRatio(lastItem);
                for (KHolder<BlockFamily> nextFamily : BlockFamilies.findQuickSwitch(lastItem, player.isCreative())) {
                    if (!iteratedFamilies.add(nextFamily.value())) continue;
                    for (Item nextItem : nextFamily.value().items().toList()) {
                        if (!iteratedItems.add(nextItem)) continue;
                        float convertRatio = BlockFamilies.getConvertRatio(nextItem);
                        CConvertItemPacket.Entry entry3 = new CConvertItemPacket.Entry(parentEntry.ratio() * ratio / convertRatio);
                        entry3.steps().addAll(parentEntry.steps());
                        entry3.steps().add((Pair<ResourceLocation, Item>)Pair.of((Object)nextFamily.key(), (Object)nextItem));
                        if (!addedItems.contains(nextItem)) {
                            group2.entries().add(entry3);
                            addedItems.add(nextItem);
                        }
                        if (entry3.steps().size() >= 4 || !nextFamily.value().switchAttrs().cascading()) continue;
                        unresolved.add(entry3);
                    }
                }
            }
            if (group2.entries().isEmpty()) continue;
            groups.add(group2);
        }
        if (player.isCreative()) {
            return groups;
        }
        Predicate<CConvertItemPacket.Entry> filter = entry -> {
            if (entry.ratio() >= 1.0f) {
                return false;
            }
            return !player.getInventory().hasAnyMatching($ -> $.is(entry.item()));
        };
        int count = 0;
        for (CConvertItemPacket.Group group3 : groups) {
            group3.entries().removeIf(filter);
            count += group3.entries().size();
        }
        if (count <= 1) {
            return List.of();
        }
        groups.removeIf(group -> group.entries().isEmpty());
        return groups;
    }

    public static boolean startDestroyBlock(BlockPos pos, Direction face) {
        LocalPlayer player = BuildersButton.ensureBuilderMode();
        return player != null;
    }

    public static boolean performUseItemOn(InteractionHand hand, BlockHitResult hitResult) {
        LocalPlayer player = BuildersButton.ensureBuilderMode();
        if (player == null) {
            return false;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        BuilderModePreview preview = BuildersButton.getPreviewRenderer();
        KHolder<BuilderRule> rule = preview.rule;
        BlockPos pos = preview.pos;
        List<BlockPos> positions = preview.positions;
        if (rule == null || positions.isEmpty() || !hitResult.getBlockPos().equals((Object)pos)) {
            return true;
        }
        KPacketSender.sendToServer(new CApplyBuilderRulePacket(new UseOnContext((Player)player, hand, hitResult), rule, positions));
        return true;
    }

    @Nullable
    private static LocalPlayer ensureBuilderMode() {
        if (!BuildersButton.isBuilderModeOn()) {
            return null;
        }
        return Minecraft.getInstance().player;
    }

    public static void renderDebugText(List<String> left, List<String> right) {
        if (!BuildersButton.isBuilderModeOn()) {
            return;
        }
        left.add("Builder Mode is on, long press %s to toggle".formatted(Objects.requireNonNull(CustomizationClient.buildersButtonKey).getTranslatedKeyMessage().getString()));
    }

    public static boolean cancelRenderHighlight() {
        return !BuildersButton.getPreviewRenderer().positions.isEmpty();
    }
}

