/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.BelowOrAboveWidgetTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.lwjgl.glfw.GLFW;
import snownee.kiwi.customization.builder.ItemButton;
import snownee.kiwi.customization.builder.PanelLayout;
import snownee.kiwi.customization.network.CConvertItemPacket;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.network.KPacketSender;
import snownee.kiwi.util.LerpedFloat;
import snownee.kiwi.util.MultilineTooltip;

public class ConvertScreen
extends Screen {
    @Nullable
    private static ConvertScreen lingeringScreen;
    private final boolean inContainer;
    private final boolean inCreativeContainer;
    @Nullable
    private final Slot slot;
    private final int slotIndex;
    private final Collection<CConvertItemPacket.Group> groups;
    private final LerpedFloat openProgress = LerpedFloat.linear();
    private PanelLayout layout;
    private final Vector2i originalMousePos;
    private final ItemStack sourceItem;
    private ClientTooltipPositioner forcedTooltipPositioner;
    private final Set<Item> chosenItems = Sets.newIdentityHashSet();
    @Nullable
    private AbstractWidget lastFocused;

    private static Vector2i getMousePos() {
        Minecraft mc = Minecraft.getInstance();
        MouseHandler mouseHandler = mc.mouseHandler;
        return new Vector2i((int)mouseHandler.xpos(), (int)mouseHandler.ypos());
    }

    public ConvertScreen(@Nullable Screen parent, @Nullable Slot slot, int slotIndex, List<CConvertItemPacket.Group> groups) {
        super((Component)Component.translatable((String)"gui.kiwi.builder.convert"));
        this.slot = slot;
        this.slotIndex = slotIndex;
        this.groups = groups;
        this.inContainer = parent instanceof AbstractContainerScreen;
        this.inCreativeContainer = this.inContainer && parent instanceof CreativeModeInventoryScreen;
        this.originalMousePos = ConvertScreen.getMousePos();
        this.openProgress.setValue(0.2f);
        this.openProgress.chase(1.0, 0.8, LerpedFloat.Chaser.EXP);
        this.sourceItem = this.getSourceItem();
        this.chosenItems.add(this.sourceItem.getItem());
    }

    private ItemStack getSourceItem() {
        if (this.slot != null) {
            return this.slot.getItem();
        }
        Inventory inventory = Objects.requireNonNull(Minecraft.getInstance().player).getInventory();
        return inventory.getItem(this.slotIndex);
    }

    /*
     * WARNING - void declaration
     */
    protected void init() {
        void var9_18;
        Vector2f anchor;
        int y;
        this.lastFocused = null;
        this.layout = new PanelLayout(2);
        int step = this.inContainer ? 19 : 21;
        int xStart = 0;
        int yStart = 0;
        int curX = xStart;
        int curY = yStart;
        HashSet accepted = Sets.newHashSet();
        LocalPlayer player = Objects.requireNonNull(this.getMinecraft().player);
        for (CConvertItemPacket.Group group : this.groups) {
            accepted.addAll(group.entries());
        }
        int itemsPerLine = accepted.size() > 30 ? 11 : 4;
        for (CConvertItemPacket.Group group : this.groups) {
            for (CConvertItemPacket.Entry entry : group.entries()) {
                List<Component> tooltip;
                if (!accepted.contains(entry)) continue;
                ItemStack itemStack = new ItemStack((ItemLike)entry.item());
                ItemButton button = (ItemButton)ItemButton.builder(itemStack, this.inContainer, btn -> this.shortPress((ItemButton)btn, entry)).bounds(curX, curY, 21, 21).build();
                button.onPress = btn -> {
                    if (btn.pressTime() >= 10) {
                        this.longPress((ItemButton)((Object)((Object)btn)), entry);
                    }
                };
                button.onRelease = btn -> {
                    if (!ConvertScreen.hasControlDown()) {
                        this.onClose();
                    }
                };
                button.setAlpha(this.inContainer ? 0.2f : 0.8f);
                if (Platform.isProduction()) {
                    tooltip = List.of(itemStack.getHoverName());
                } else {
                    String steps = String.join((CharSequence)" -> ", entry.steps().stream().map(Pair::getFirst).map(Objects::toString).toList());
                    tooltip = List.of(itemStack.getHoverName(), Component.literal((String)steps).withStyle(ChatFormatting.GRAY));
                }
                button.setTooltip(MultilineTooltip.create(tooltip));
                if (this.lastFocused == null && itemStack.is(this.sourceItem.getItem())) {
                    this.lastFocused = button;
                }
                this.layout.addWidget((AbstractWidget)button);
                if ((curX += step) < xStart + itemsPerLine * step) continue;
                curX = xStart;
                curY += step;
            }
        }
        if (this.inContainer) {
            int n = this.width / 2;
            y = this.height / 2;
            anchor = new Vector2f(0.5f, 0.5f);
        } else {
            if (this.slotIndex == 40) {
                HumanoidArm humanoidarm = player.getMainArm().getOpposite();
                if (humanoidarm == HumanoidArm.LEFT) {
                    int n = this.width / 2 - 91 - 29 + 11;
                } else {
                    int n = this.width / 2 + 91 + 17;
                }
            } else {
                int n = this.width / 2 - 91 + 11 + player.getInventory().selected * 20;
            }
            y = this.height - 24;
            anchor = new Vector2f(0.5f, 1.0f);
        }
        this.layout.bind(this, new Vector2i((int)var9_18, y), anchor);
        if (this.lastFocused != null) {
            this.moveMouseOn(this.lastFocused);
        }
        Rect2i bounds = this.layout.bounds();
        ScreenRectangle rect = new ScreenRectangle(bounds.getX() - 2, bounds.getY() - 2, 10000, 10000);
        this.forcedTooltipPositioner = new BelowOrAboveWidgetTooltipPositioner(rect);
    }

    private void moveMouseOn(AbstractWidget button) {
        this.setFocused((GuiEventListener)button);
        Window window = Objects.requireNonNull(this.getMinecraft().getWindow());
        double scale = window.getGuiScale();
        GLFW.glfwSetCursorPos((long)window.getWindow(), (double)((double)(button.getX() + 15) * scale), (double)((double)(button.getY() + 15) * scale));
    }

    private void longPress(ItemButton button, CConvertItemPacket.Entry entry) {
        boolean convertOne = ConvertScreen.hasControlDown();
        if (convertOne) {
            this.shortPress(button, entry);
        } else if ((!this.inContainer || Objects.requireNonNull(this.getMinecraft().player).containerMenu instanceof InventoryMenu) && button.pressTime() >= 15) {
            Item from = this.getSourceItem().getItem();
            KPacketSender.sendToServer(new CConvertItemPacket(false, this.slotIndex, entry, from, CConvertItemPacket.Action.CONVERT_FAMILY));
            this.onClose();
        }
    }

    private void shortPress(ItemButton button, CConvertItemPacket.Entry entry) {
        LocalPlayer player = Objects.requireNonNull(this.getMinecraft().player);
        boolean creative = player.isCreative();
        ItemStack sourceItem = this.getSourceItem();
        boolean convertOne = ConvertScreen.hasControlDown();
        if (convertOne && !creative && sourceItem.getCount() <= 1) {
            this.onClose();
        }
        Item from = sourceItem.getItem();
        Item to = button.item().getItem();
        if (!(creative && convertOne || from != to)) {
            return;
        }
        this.chosenItems.add(to);
        if (this.inCreativeContainer && convertOne) {
            KPacketSender.sendToServer(new CConvertItemPacket(false, -500, entry, from, CConvertItemPacket.Action.CONVERT_ONE));
        } else if (this.inCreativeContainer) {
            Objects.requireNonNull(this.slot);
            ItemStack newItem = to.getDefaultInstance();
            newItem.setCount(this.slot.getItem().getCount());
            newItem.setPopTime(5);
            this.slot.setByPlayer(newItem);
            NonNullList slots = player.inventoryMenu.slots;
            for (int i = 0; i < slots.size(); ++i) {
                if (((Slot)slots.get(i)).getItem() != newItem) continue;
                Objects.requireNonNull(this.getMinecraft().gameMode).handleCreativeModeItemAdd(newItem, i);
                CConvertItemPacket.Handler.playPickupSound((Player)player);
                break;
            }
        } else {
            KPacketSender.sendToServer(new CConvertItemPacket(this.inContainer, this.slotIndex, entry, from, convertOne ? CConvertItemPacket.Action.CONVERT_ONE : CConvertItemPacket.Action.CONVERT_ALL));
        }
    }

    public void tick() {
        this.openProgress.tickChaser();
        if (!this.isClosing() && !this.chosenItems.contains(this.getSourceItem().getItem())) {
            this.onClose();
        }
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (listener instanceof ItemButton) {
            ItemButton button = (ItemButton)listener;
            this.lastFocused = button;
        }
        super.setFocused(listener);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        Rect2i bounds;
        Rect2i tolerance;
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (pButton == 0 && !(tolerance = new Rect2i((bounds = this.layout.bounds()).getX() - 10, bounds.getY() - 10, bounds.getWidth() + 20, bounds.getHeight() + 20)).contains((int)pMouseX, (int)pMouseY)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY == 0.0) {
            return false;
        }
        int index = -1;
        List<AbstractWidget> widgets = this.layout.widgets();
        if (widgets.isEmpty()) {
            return false;
        }
        if (this.lastFocused != null) {
            index = widgets.indexOf(this.lastFocused);
        }
        if (index == -1 && scrollY > 0.0) {
            index = widgets.size();
        }
        if ((index += scrollY > 0.0 ? -1 : 1) < 0) {
            index = widgets.size() - 1;
        } else if (index >= widgets.size()) {
            index = 0;
        }
        this.lastFocused = widgets.get(index);
        this.moveMouseOn(this.lastFocused);
        return true;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Objects.requireNonNull(this.minecraft);
        PoseStack pose = pGuiGraphics.pose();
        this.layout.update();
        Vector2i pos = this.layout.getAnchoredPos();
        float openValue = this.openProgress.getValue(pPartialTick);
        pose.pushPose();
        pose.translate((float)pos.x, (float)pos.y, 0.0f);
        pose.scale(openValue, openValue, openValue);
        pose.translate((float)(-pos.x), (float)(-pos.y), 0.0f);
        if (this.inContainer) {
            Rect2i bounds = this.layout.bounds();
            pGuiGraphics.blitSprite(ResourceLocation.withDefaultNamespace((String)"recipe_book/overlay_recipe"), bounds.getX() - 2, bounds.getY() - 2, 0, bounds.getWidth() + 3, bounds.getHeight() + 3);
        }
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pose.popPose();
    }

    public void renderBackground(GuiGraphics p_283688_, int p_296369_, int p_296477_, float p_294317_) {
    }

    public void setTooltipForNextRenderPass(List<FormattedCharSequence> list, ClientTooltipPositioner tooltipPositioner, boolean force) {
        float openValue = this.openProgress.getValue(Objects.requireNonNull(this.minecraft).getTimer().getGameTimeDeltaPartialTick(true));
        if (openValue > 0.95f) {
            super.setTooltipForNextRenderPass(list, this.forcedTooltipPositioner, force);
        }
    }

    public void onClose() {
        this.openProgress.chase(0.0, 0.8, LerpedFloat.Chaser.EXP);
        lingeringScreen = this;
        super.onClose();
        if (this.inContainer) {
            GLFW.glfwSetCursorPos((long)this.getMinecraft().getWindow().getWindow(), (double)this.originalMousePos.x, (double)this.originalMousePos.y);
        }
    }

    public boolean isClosing() {
        return this.openProgress.getChaseTarget() == 0.0f;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void renderLingering(GuiGraphics pGuiGraphics) {
        if (lingeringScreen == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null || mc.getOverlay() != null || ConvertScreen.lingeringScreen.openProgress.settled()) {
            lingeringScreen = null;
            return;
        }
        lingeringScreen.render(pGuiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, mc.getTimer().getGameTimeDeltaPartialTick(true));
    }

    public static void tickLingering() {
        if (lingeringScreen != null) {
            lingeringScreen.tick();
        }
    }
}

