/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ExportCreativeTabsCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.literal((String)"creative_tabs").then(Commands.argument((String)"signPos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ExportCreativeTabsCommand.exportCreativeTabs((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"signPos")))));
    }

    private static int exportCreativeTabs(CommandSourceStack source, BlockPos pos) {
        DataResult<Pair<ResourceLocation, Direction>> result = ExportCreativeTabsCommand.checkIsValidSign(source, pos);
        if (result.error().isPresent()) {
            source.sendFailure((Component)Component.literal((String)((DataResult.Error)result.error().get()).message()));
            return 0;
        }
        Direction direction = (Direction)((Pair)result.result().orElseThrow()).getSecond();
        ServerLevel level = source.getLevel();
        List<Pair<BlockPos, Container>> containers = ExportCreativeTabsCommand.findContainerSequence(level, pos, direction);
        LinkedHashMap data = Maps.newLinkedHashMap();
        try {
            LinkedHashSet<String> items = ExportCreativeTabsCommand.collectItems(source, containers);
            if (!items.isEmpty()) {
                data.put(((ResourceLocation)((Pair)result.result().orElseThrow()).getFirst()).toString(), items);
            }
            for (Direction leftOrRight : List.of(Rotation.CLOCKWISE_90.rotate(direction), Rotation.COUNTERCLOCKWISE_90.rotate(direction))) {
                BlockPos.MutableBlockPos mutablePos = pos.mutable().move(leftOrRight);
                int failed = 0;
                while (failed < 5) {
                    mutablePos.move(leftOrRight);
                    DataResult<Pair<ResourceLocation, Direction>> result2 = ExportCreativeTabsCommand.checkIsValidSign(source, (BlockPos)mutablePos);
                    if (result2.error().isPresent()) {
                        ++failed;
                        continue;
                    }
                    Pair pair = (Pair)result2.result().orElseThrow();
                    if (direction != pair.getSecond()) {
                        ++failed;
                        continue;
                    }
                    String tabId = ((ResourceLocation)pair.getFirst()).toString();
                    if (data.containsKey(tabId)) {
                        failed = 0;
                        continue;
                    }
                    containers = ExportCreativeTabsCommand.findContainerSequence(level, (BlockPos)mutablePos, direction);
                    items = ExportCreativeTabsCommand.collectItems(source, containers);
                    if (!items.isEmpty()) {
                        data.put(tabId, items);
                    }
                    failed = 0;
                }
            }
        }
        catch (RuntimeException e) {
            source.sendFailure((Component)Component.literal((String)e.getMessage()));
            return 0;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("exported_creative_tabs.json", new String[0]), new OpenOption[0]);){
            new Gson().toJson((Object)data, (Appendable)writer);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)e.getMessage()));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"Creative tabs exported"), false);
        return 1;
    }

    private static List<Pair<BlockPos, Container>> findContainerSequence(ServerLevel level, BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        ArrayList containers = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        while (true) {
            BaseContainerBlockEntity blockEntity;
            mutablePos.move(direction);
            BlockEntity blockEntity2 = level.getBlockEntity((BlockPos)mutablePos);
            if (!(blockEntity2 instanceof BaseContainerBlockEntity)) break;
            BaseContainerBlockEntity container = blockEntity = (BaseContainerBlockEntity)blockEntity2;
            Block block = blockEntity.getBlockState().getBlock();
            if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                if (ChestBlock.getConnectedDirection((BlockState)blockEntity.getBlockState()) == direction.getOpposite()) continue;
                container = ChestBlock.getContainer((ChestBlock)chestBlock, (BlockState)blockEntity.getBlockState(), (Level)Objects.requireNonNull(blockEntity.getLevel()), (BlockPos)mutablePos, (boolean)true);
            }
            if (!set.add(container)) continue;
            containers.add(Pair.of((Object)blockEntity.getBlockPos(), (Object)container));
        }
        return containers;
    }

    private static LinkedHashSet<String> collectItems(CommandSourceStack source, List<Pair<BlockPos, Container>> pairs) {
        ServerLevel level = source.getLevel();
        LinkedHashSet items = Sets.newLinkedHashSet();
        for (Pair<BlockPos, Container> pair : pairs) {
            level.setBlockAndUpdate(((BlockPos)pair.getFirst()).below(), Blocks.YELLOW_WOOL.defaultBlockState());
        }
        for (Pair<BlockPos, Container> pair : pairs) {
            Container container = (Container)pair.getSecond();
            for (int i = 0; i < container.getContainerSize(); ++i) {
                String item;
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty() || items.add(item = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString())) continue;
                for (Pair<BlockPos, Container> pair1 : pairs) {
                    if (!((Container)pair1.getSecond()).hasAnyMatching($ -> ItemStack.isSameItemSameComponents((ItemStack)$, (ItemStack)stack))) continue;
                    level.setBlockAndUpdate(((BlockPos)pair1.getFirst()).below(), Blocks.RED_WOOL.defaultBlockState());
                }
                throw new IllegalStateException("Duplicate item: %s (%s)".formatted(stack.getHoverName().getString(), item));
            }
            level.setBlockAndUpdate(((BlockPos)pair.getFirst()).below(), Blocks.LIME_WOOL.defaultBlockState());
        }
        return items;
    }

    private static DataResult<Pair<ResourceLocation, Direction>> checkIsValidSign(CommandSourceStack source, BlockPos pos) {
        ServerLevel level = source.getLevel();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof SignBlock)) {
            return DataResult.error(() -> "Target block is not a sign");
        }
        SignBlock block2 = (SignBlock)block;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SignBlockEntity)) {
            return DataResult.error(() -> "Target block is not a sign");
        }
        SignBlockEntity blockEntity2 = (SignBlockEntity)blockEntity;
        String signText = String.join((CharSequence)"", Arrays.stream(blockEntity2.getFrontText().getMessages(false)).map(Component::getString).toList());
        if (signText.isBlank()) {
            return DataResult.error(() -> "The sign is empty");
        }
        ResourceLocation tabId = ResourceLocation.tryParse((String)signText);
        if (tabId == null) {
            return DataResult.error(() -> "The sign text is not a valid resource location");
        }
        Direction direction = Direction.fromYRot((double)block2.getYRotationDegrees(blockState)).getOpposite();
        return DataResult.success((Object)Pair.of((Object)tabId, (Object)direction));
    }
}

