/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record MouldingShape(VoxelShape[] shapes) implements ShapeGenerator
{
    private static final int[] mapping = new int[20];

    private static void prepareMapping() {
        StairsShape[] stairsShapes = StairsShape.values();
        for (int i = 0; i < 5; ++i) {
            StairsShape stairsShape = stairsShapes[i];
            int stairsShapeIndex = switch (stairsShape) {
                default -> throw new MatchException(null, null);
                case StairsShape.STRAIGHT -> 0;
                case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> 1;
                case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> 2;
            };
            int rotationOffset = switch (stairsShape) {
                case StairsShape.INNER_LEFT, StairsShape.OUTER_LEFT -> 0;
                default -> 1;
            };
            for (int j = 0; j < 4; ++j) {
                MouldingShape.mapping[i * 4 + j] = stairsShapeIndex * 4 + (j + rotationOffset) % 4;
            }
        }
    }

    public static ShapeGenerator create(ShapeGenerator northStraightGenerator) {
        VoxelShape northStraight = ShapeGenerator.Unit.unboxOrThrow(northStraightGenerator);
        VoxelShape northInner = Shapes.or((VoxelShape)northStraight, (VoxelShape)VoxelUtil.rotateHorizontal(northStraight, Direction.NORTH.getClockWise()));
        VoxelShape northOuter = Shapes.join((VoxelShape)northStraight, (VoxelShape)VoxelUtil.rotateHorizontal(northStraight, Direction.NORTH.getClockWise()), (BooleanOp)BooleanOp.AND);
        VoxelShape[] shapes = (VoxelShape[])Stream.of(northStraight, northInner, northOuter).flatMap($ -> Direction.Plane.HORIZONTAL.stream().map(direction -> VoxelUtil.rotateHorizontal($, direction))).toArray(VoxelShape[]::new);
        VoxelShape[] mappedShapes = new VoxelShape[20];
        for (int i = 0; i < mappedShapes.length; ++i) {
            mappedShapes[i] = shapes[mapping[i]];
        }
        return new MouldingShape(mappedShapes);
    }

    @Override
    public VoxelShape getShape(BlockState blockState, CollisionContext context) {
        int shape = ((StairsShape)blockState.getValue((Property)BlockStateProperties.STAIRS_SHAPE)).ordinal();
        int facing = ((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).get2DDataValue();
        return this.shapes[shape * 4 + facing];
    }

    static {
        MouldingShape.prepareMapping();
    }

    public record Unbaked(UnbakedShape wrapped) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("north_straight").forGetter(Unbaked::wrapped)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return MouldingShape.create(this.wrapped.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.wrapped);
        }
    }
}

