/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.data;

import com.mojang.serialization.MapCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.recipe.AlternativesIngredient;
import snownee.kiwi.recipe.CustomIngredientSerializer;
import snownee.kiwi.recipe.EvalCondition;
import snownee.kiwi.recipe.ModuleLoadedCondition;
import snownee.kiwi.recipe.crafting.KiwiShapelessRecipe;
import snownee.kiwi.recipe.crafting.NoContainersShapedRecipe;

@KiwiModule(value="data")
public final class DataModule
extends AbstractModule {
    public static final KiwiGO<RecipeSerializer<NoContainersShapedRecipe>> SHAPED_NO_CONTAINERS = DataModule.go(NoContainersShapedRecipe.Serializer::new);
    public static final KiwiGO<RecipeSerializer<KiwiShapelessRecipe>> SHAPELESS = DataModule.go(KiwiShapelessRecipe.Serializer::new);
    public static final KiwiGO<MapCodec<ModuleLoadedCondition>> IS_LOADED = DataModule.go(() -> ModuleLoadedCondition.CODEC, NeoForgeRegistries.Keys.CONDITION_CODECS);
    public static final KiwiGO<MapCodec<EvalCondition>> EVAL = DataModule.go(() -> EvalCondition.CODEC, NeoForgeRegistries.Keys.CONDITION_CODECS);

    public DataModule() {
        CustomIngredientSerializer.register(AlternativesIngredient.SERIALIZER);
    }

    @KiwiModule.LoadingCondition(value={"data"})
    public static boolean shouldLoad(LoadingContext ctx) {
        return Kiwi.enableDataModule || KiwiCommonConfig.getBooleanVar("EnableDataModule");
    }
}

