/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.util.WrappedBlockGetter;

public class SimulationBlockGetter
extends WrappedBlockGetter {
    private BlockEntity simulatedBlockEntity;
    private BlockPos simulatedPos;
    private boolean useSelfLight;
    private int globalLight = -1;

    public void setBlockEntity(BlockEntity blockEntity) {
        this.simulatedBlockEntity = blockEntity;
    }

    public void setPos(BlockPos pos) {
        this.simulatedPos = pos;
    }

    @Override
    public BlockEntity getBlockEntity(BlockPos pos) {
        if (this.simulatedBlockEntity != null && pos.equals((Object)this.simulatedPos)) {
            return this.simulatedBlockEntity;
        }
        return super.getBlockEntity(pos);
    }

    public void useSelfLight(boolean useSelfLight) {
        this.useSelfLight = useSelfLight;
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        if (this.globalLight != -1 && !pos.equals((Object)this.simulatedPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (this.useSelfLight && this.simulatedPos != null && this.simulatedPos.distManhattan((Vec3i)pos) < 3) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.getBlockState(pos);
    }

    public int getBrightness(LightLayer lightType, BlockPos pos) {
        if (this.globalLight != -1) {
            return this.globalLight;
        }
        if (this.useSelfLight && this.simulatedPos != null && this.simulatedPos.distManhattan((Vec3i)pos) < 3) {
            pos = this.simulatedPos;
        }
        return super.getBrightness(lightType, pos);
    }

    public void setOverrideLight(int i) {
        this.globalLight = i;
    }
}

