/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.client.screen.widget;

import com.blakebr0.mysticalautomation.client.screen.FarmerScreen;
import com.blakebr0.mysticalautomation.lib.ModTooltips;
import java.util.function.IntSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class FarmerStageProgressWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE = FarmerScreen.BACKGROUND;
    private final IntSupplier progress;
    private final IntSupplier total;
    private final IntSupplier stages;

    public FarmerStageProgressWidget(int x, int y, IntSupplier progress, IntSupplier total, IntSupplier stages) {
        super(x, y, 2, 16, (Component)Component.literal((String)"Farmer Stage Progress"));
        this.progress = progress;
        this.total = total;
        this.stages = stages;
        this.active = false;
    }

    protected void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        int offset = this.getProgressScaled();
        gfx.blit(TEXTURE, this.getX(), this.getY(), 177, 0, this.width, this.height);
        gfx.blit(TEXTURE, this.getX(), this.getY() + this.height - offset, 177 + this.width, this.height - offset, this.width, offset);
        int stages = this.stages.getAsInt();
        if (stages > 0 && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height) {
            Font font = Minecraft.getInstance().font;
            double stage = (double)stages * ((double)this.progress.getAsInt() / (double)this.total.getAsInt());
            MutableComponent text = ModTooltips.STAGE.args(new Object[]{(int)Math.floor(stage), stages}).color(ChatFormatting.WHITE).build();
            gfx.renderTooltip(font, (Component)text, mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    private int getProgressScaled() {
        int i = this.progress.getAsInt();
        int j = this.total.getAsInt();
        return j != 0 && i != 0 ? i * this.height / j : 0;
    }
}

