/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.network.payload;

import com.blakebr0.mysticalautomation.MysticalAutomation;
import com.blakebr0.mysticalautomation.tileentity.InfuserTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record InfuserSelectIndexPayload(BlockPos pos, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InfuserSelectIndexPayload> TYPE = new CustomPacketPayload.Type(MysticalAutomation.resource("infuser_select_index"));
    public static final StreamCodec<FriendlyByteBuf, InfuserSelectIndexPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, InfuserSelectIndexPayload::pos, (StreamCodec)ByteBufCodecs.VAR_INT, InfuserSelectIndexPayload::index, InfuserSelectIndexPayload::new);

    public CustomPacketPayload.Type<InfuserSelectIndexPayload> type() {
        return TYPE;
    }

    public static void handleServer(InfuserSelectIndexPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(payload.pos);
            if (tile instanceof InfuserTileEntity) {
                InfuserTileEntity machine = (InfuserTileEntity)tile;
                int selectedIndex = machine.getSelectedIndex();
                if (selectedIndex == payload.index) {
                    machine.setSelectedIndex(0);
                } else {
                    machine.setSelectedIndex(payload.index);
                }
            }
        });
    }
}

