/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.SidedInventoryWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.ContainerDataBuilder;
import com.blakebr0.mysticalagriculture.api.machine.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeTier;
import com.blakebr0.mysticalautomation.block.FertilizerBlock;
import com.blakebr0.mysticalautomation.container.FertilizerContainer;
import com.blakebr0.mysticalautomation.init.ModTileEntities;
import com.blakebr0.mysticalautomation.lib.ModTags;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class FertilizerTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int[] INPUT_SLOTS = IntStream.rangeClosed(0, 7).toArray();
    private static final int FUEL_SLOT = 8;
    public static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 200;
    public static final int FUEL_USAGE = 40;
    public static final int SCAN_FUEL_USAGE = 10;
    public static final int FUEL_CAPACITY = 80000;
    public static final int BASE_RANGE = 1;
    private final BaseItemStackHandler inventory = FertilizerTileEntity.createInventoryHandler(slot -> this.setChanged());
    private final MachineUpgradeItemStackHandler upgradeInventory = new MachineUpgradeItemStackHandler();
    private final DynamicEnergyStorage energy = new DynamicEnergyStorage(80000, () -> ((FertilizerTileEntity)this).setChangedFast());
    private final SidedInventoryWrapper[] sidedInventoryWrappers = SidedInventoryWrapper.create((BaseItemStackHandler)this.inventory, List.of(Direction.UP, Direction.DOWN, Direction.NORTH), this::canInsertStackSided, null);
    private final ContainerData dataAccess = ContainerDataBuilder.builder().sync(() -> ((DynamicEnergyStorage)this.energy).getEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setEnergyStored(arg_0)).sync(() -> ((DynamicEnergyStorage)this.energy).getMaxEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setMaxEnergyStorage(arg_0)).sync(() -> this.fuelLeft, value -> {
        this.fuelLeft = value;
    }).sync(() -> this.fuelItemValue, value -> {
        this.fuelItemValue = value;
    }).build();
    private MachineUpgradeTier tier;
    private int progress;
    private int lastScanIndex = -1;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public FertilizerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FERTILIZER.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.mysticalautomation.fertilizer");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FertilizerContainer(i, inventory, this.inventory, this.upgradeInventory, this.dataAccess, this.getBlockPos());
    }

    public MachineUpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.lastScanIndex = tag.getInt("LastScanIndex");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("LastScanIndex", this.lastScanIndex);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FertilizerTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(8);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(8, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage(tier.getFuelCapacity(80000));
            }
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        tile.isRunning = false;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage() && !level.hasNeighborSignal(pos)) {
            int slot = tile.findNextFertilizerSlot();
            if (slot != -1) {
                tile.isRunning = true;
                ++tile.progress;
                if (tile.progress >= tile.getOperationTime()) {
                    BonemealableBlock bonemealable;
                    BlockPos nextPos = tile.findNextPosition((Direction)state.getValue((Property)FertilizerBlock.FACING));
                    BlockState plantState = level.getBlockState(nextPos);
                    Block plantBlock = plantState.getBlock();
                    if (plantBlock instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)plantBlock).isValidBonemealTarget((LevelReader)level, nextPos, plantState)) {
                        ItemStack stack = tile.inventory.getStackInSlot(slot);
                        BlockHitResult hitResult = new BlockHitResult(nextPos.getCenter(), Direction.DOWN, nextPos, false);
                        UseOnContext context = new UseOnContext(level, null, InteractionHand.MAIN_HAND, stack, hitResult);
                        if (stack.getItem().useOn(context) == InteractionResult.SUCCESS) {
                            tile.energy.extractEnergy(tile.getFuelUsage(), false);
                        } else {
                            tile.energy.extractEnergy(10, false);
                        }
                    } else {
                        tile.energy.extractEnergy(10, false);
                    }
                    tile.progress = 0;
                }
                tile.setChangedFast();
            } else if (tile.progress > 0) {
                tile.progress = 0;
                tile.setChangedFast();
            }
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)FertilizerBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return FertilizerTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(@Nullable OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)9, (OnContentsChangedFunction)onContentsChanged, handler -> handler.setCanInsert((slot, stack) -> {
            if (ArrayUtils.contains((int[])INPUT_SLOTS, (int)slot)) {
                return stack.is(ModTags.Items.FERTILIZERS);
            }
            return true;
        }));
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public IItemHandler getSidedInventory(@Nullable Direction direction) {
        Direction direction2 = direction;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"UP", "DOWN"}, (Direction)direction2, n)) {
            case 0 -> this.sidedInventoryWrappers[0];
            case 1 -> this.sidedInventoryWrappers[1];
            default -> this.sidedInventoryWrappers[2];
        };
    }

    private int getOperationTime() {
        return this.tier == null ? 200 : this.tier.getOperationTime(200);
    }

    private int getFuelUsage() {
        return this.tier == null ? 40 : this.tier.getFuelUsage(40);
    }

    private int findNextFertilizerSlot() {
        for (int slot : INPUT_SLOTS) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    private BlockPos findNextPosition(Direction direction) {
        int index = this.lastScanIndex + 1;
        int range = this.tier != null ? 1 + this.tier.getAddedRange() : 1;
        int size = range * 2 + 1;
        if (index >= (int)Math.pow(size, 2.0)) {
            index = 0;
        }
        this.lastScanIndex = index;
        int xOffset = index % size - range;
        int zOffset = index / size - range;
        BlockPos center = this.getBlockPos().relative(direction, range + 1);
        return switch (direction) {
            case Direction.NORTH -> new BlockPos(center.getX() + xOffset, center.getY(), center.getZ() - zOffset);
            case Direction.SOUTH -> new BlockPos(center.getX() - xOffset, center.getY(), center.getZ() + zOffset);
            case Direction.EAST -> new BlockPos(center.getX() + zOffset, center.getY(), center.getZ() + xOffset);
            case Direction.WEST -> new BlockPos(center.getX() - zOffset, center.getY(), center.getZ() - xOffset);
            default -> center;
        };
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, @Nullable Direction direction) {
        if (direction == null) {
            return true;
        }
        if (ArrayUtils.contains((int[])INPUT_SLOTS, (int)slot) && direction == Direction.UP) {
            return true;
        }
        if (slot == 8 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.isFuel((ItemStack)stack);
        }
        return false;
    }
}

