/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.loading.json.raw.Model;
import software.bernie.geckolib.loading.json.typeadapter.KeyFramesAdapter;
import software.bernie.geckolib.loading.object.BakedAnimations;

public final class FileLoader {
    public static BakedAnimations loadAnimationsFile(ResourceLocation location, ResourceManager manager) {
        if (location.getPath().endsWith(".geo.json")) {
            throw new IllegalArgumentException("Geo model file found in animations folder!");
        }
        if (!location.getPath().endsWith(".animation.json")) {
            GeckoLibConstants.LOGGER.warn("Found animation file with improper file name format; animation files should end in .animation.json: '" + String.valueOf(location) + "'");
        }
        return (BakedAnimations)KeyFramesAdapter.GEO_GSON.fromJson((JsonElement)GsonHelper.getAsJsonObject((JsonObject)FileLoader.loadFile(location, manager), (String)"animations"), BakedAnimations.class);
    }

    public static Model loadModelFile(ResourceLocation location, ResourceManager manager) {
        if (location.getPath().endsWith(".animation.json")) {
            throw new IllegalArgumentException("Animation file found in geo models folder!");
        }
        if (!location.getPath().endsWith(".geo.json")) {
            GeckoLibConstants.LOGGER.warn("Found geo model file with improper file name format; geo model files should end in .geo.json: '" + String.valueOf(location) + "'");
        }
        return (Model)KeyFramesAdapter.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), Model.class);
    }

    public static JsonObject loadFile(ResourceLocation location, ResourceManager manager) {
        return (JsonObject)GsonHelper.fromJson((Gson)KeyFramesAdapter.GEO_GSON, (String)FileLoader.getFileContents(location, manager), JsonObject.class);
    }

    public static String getFileContents(ResourceLocation location, ResourceManager manager) {
        String string;
        block8: {
            InputStream inputStream = manager.getResourceOrThrow(location).open();
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    GeckoLibConstants.LOGGER.error("Couldn't load " + String.valueOf(location), (Throwable)e);
                    throw new RuntimeException(new FileNotFoundException(location.toString()));
                }
            }
            inputStream.close();
        }
        return string;
    }
}

