/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.blocks;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees.lib.util.LootHelper;
import com.davenonymous.bonsaitrees.lib.util.StackHelper;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.config.GameplayConfig;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.UnknownNullability;

public class BonsaiPotBlockProduction
implements INBTSerializable<CompoundTag> {
    protected BonsaiPotBlockEntity potBlock;
    protected boolean canGrow;
    public int cutCooldown;
    public int growTicks;
    public ItemStack saplingStack = ItemStack.EMPTY;
    List<ItemStack> lootQueue;

    public BonsaiPotBlockProduction(BonsaiPotBlockEntity potBlock) {
        this.potBlock = potBlock;
        this.lootQueue = new ArrayList<ItemStack>();
    }

    public void init() {
        this.canGrow = this.canGrow();
        this.saplingStack = this.potBlock.inventories.getSaplingStack().copy();
    }

    public void tick() {
        if (!this.canGrow) {
            return;
        }
        if (this.getRequiredGrowTicks() == 0) {
            return;
        }
        if (this.cutCooldown > 0) {
            --this.cutCooldown;
            return;
        }
        if (this.growTicks < this.getRequiredGrowTicks()) {
            ++this.growTicks;
            return;
        }
        if (!this.potBlock.getRedstoneMode().resolve(this.potBlock.getLevel(), this.potBlock.getBlockPos())) {
            return;
        }
        this.onProductionFinished();
    }

    private boolean canInsertAllIntoOutput(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            ItemStack simulatedStack;
            if (!ItemStack.matches((ItemStack)stack, (ItemStack)(simulatedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.potBlock.inventories.outputInventory, (ItemStack)stack, (boolean)true)))) continue;
            return false;
        }
        return true;
    }

    private void insertAllIntoOutput(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.potBlock.inventories.outputInventory, (ItemStack)stack, (boolean)false);
        }
    }

    public void onProductionFinished() {
        if (this.potBlock.getLevel().isClientSide()) {
            return;
        }
        if (this.potBlock.inventories.getToolStack().isEmpty()) {
            return;
        }
        Level level = this.potBlock.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ArrayList<ItemStack> newRolledItems = new ArrayList<ItemStack>();
            ItemStack originalToolStack = this.potBlock.inventories.getToolStack();
            if (!this.lootQueue.isEmpty()) {
                newRolledItems.addAll(this.lootQueue);
            } else {
                Optional<SoilInfo> soilInfo;
                ItemStack toolStack = originalToolStack.copy();
                LootParams.Builder lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_ENTITY, (Object)this.potBlock).withParameter(LootContextParams.BLOCK_STATE, (Object)this.potBlock.getBlockState()).withParameter(LootContextParams.ORIGIN, (Object)this.potBlock.getBlockPos().getCenter());
                ItemEnchantments enchantments = this.potBlock.inventories.enchantments;
                float extraLuck = 0.0f;
                for (Holder enchantment : enchantments.keySet()) {
                    if (enchantment.is(Enchantments.FORTUNE)) {
                        extraLuck = enchantments.getLevel(enchantment);
                        continue;
                    }
                    if (enchantment.is(Enchantments.EFFICIENCY)) continue;
                    toolStack.enchant(enchantment, enchantments.getLevel(enchantment));
                }
                if (extraLuck > 0.0f) {
                    lootParams.withLuck(extraLuck);
                }
                lootParams.withParameter(LootContextParams.TOOL, (Object)toolStack);
                ResourceKey<LootTable> lootTableId = this.getBonsaiInfo().get().lootTable();
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableId);
                int extraRolls = 0;
                ItemStack soil = this.potBlock.inventories.getSoilStack();
                if (SoilCache.isSoil(soil) && (soilInfo = this.getBonsaiInfo().get().firstMatchingSoil(SoilCache.getSoilInfo(soil).get(), this.getBonsaiInfo().get())).isPresent() && soilInfo.get().extraRolls().isPresent()) {
                    extraRolls = soilInfo.get().extraRolls().get();
                }
                LootContext lootContext = new LootContext.Builder(lootParams.create(LootContextParamSets.BLOCK)).create(lootTable.randomSequence);
                List<LootHelper.LootTableDrop> drops = LootHelper.getLootTableDrops(lootTableId, serverLevel, lootContext);
                for (LootHelper.LootTableDrop drop : drops) {
                    BlockItem blockItem;
                    BlockState state;
                    ItemStack stack = drop.stack().copy();
                    Item item2 = stack.getItem();
                    if (item2 instanceof BlockItem && (state = (blockItem = (BlockItem)item2).getBlock().defaultBlockState()).requiresCorrectToolForDrops() && !toolStack.isCorrectToolForDrops(state)) continue;
                    int rolledCount = 0;
                    for (int roll = 0; roll < stack.getCount() + extraRolls; ++roll) {
                        boolean include = drop.conditions().stream().allMatch(condition -> condition.test((Object)lootContext));
                        if (!include) continue;
                        ++rolledCount;
                    }
                    if (rolledCount == 0) continue;
                    stack.setCount(rolledCount);
                    newRolledItems.add(stack);
                }
                if (originalToolStack.isDamageableItem()) {
                    boolean toolHasEnoughDurability;
                    int toolRemainingDurability = originalToolStack.getMaxDamage() - originalToolStack.getDamageValue();
                    if (originalToolStack.getItem().builtInRegistryHolder().getKey().location().getNamespace().equals("silentgear")) {
                        --toolRemainingDurability;
                    }
                    boolean bl = toolHasEnoughDurability = GameplayConfig.toolDamageChance == 0.0 || toolRemainingDurability >= GameplayConfig.toolDamagePerCut;
                    if (!toolHasEnoughDurability) {
                        originalToolStack.hurtAndBreak(GameplayConfig.toolDamagePerCut, serverLevel, null, item -> {});
                        this.potBlock.setChanged();
                        this.potBlock.notifyClients(false);
                        return;
                    }
                }
            }
            List<ItemStack> mergedItems = StackHelper.mergeStacks(newRolledItems);
            boolean canInsert = this.canInsertAllIntoOutput(mergedItems);
            if (!canInsert) {
                if (this.lootQueue.isEmpty()) {
                    this.lootQueue.addAll(mergedItems);
                }
                this.cutCooldown = GameplayConfig.cutCooldown;
                this.growTicks = this.getRequiredGrowTicks();
            } else {
                if (originalToolStack.isDamageableItem() && GameplayConfig.toolDamageChance > serverLevel.random.nextDouble() && GameplayConfig.toolDamagePerCut > 0) {
                    originalToolStack.hurtAndBreak(GameplayConfig.toolDamagePerCut, serverLevel, null, item -> {});
                }
                this.insertAllIntoOutput(newRolledItems);
                this.lootQueue.clear();
                this.cutCooldown = 0;
                this.growTicks = 0;
            }
            this.potBlock.setChanged();
            this.potBlock.notifyClients(false);
        }
    }

    public void onInventoryChange(ItemStackHandler handler, int slot) {
        if (handler == this.potBlock.inventories.saplingInventory) {
            ItemStack newSaplingStack = this.potBlock.inventories.getSaplingStack();
            if (!ItemStack.matches((ItemStack)newSaplingStack, (ItemStack)this.saplingStack)) {
                this.saplingStack = newSaplingStack.copy();
                this.growTicks = 0;
            }
            this.canGrow = this.canGrow();
        } else if (handler == this.potBlock.inventories.soilInventory) {
            this.canGrow = this.canGrow();
        }
        if (!this.canGrow) {
            this.growTicks = 0;
        }
    }

    public boolean canGrow() {
        if (this.getBonsaiInfo().isEmpty() || this.getSoilInfo().isEmpty()) {
            return false;
        }
        BonsaiInfo bonsaiInfo = this.getBonsaiInfo().get();
        Set<SoilInfo> soilInfo = this.getSoilInfo().get();
        return bonsaiInfo.canGrowOnSoil(soilInfo);
    }

    public Optional<Set<SoilInfo>> getSoilInfo() {
        ItemStack soil = this.potBlock.inventories.getSoilStack();
        if (soil.isEmpty()) {
            return Optional.empty();
        }
        return SoilCache.getSoilInfo(soil);
    }

    public Optional<BonsaiInfo> getBonsaiInfo() {
        ItemStack sapling = this.potBlock.inventories.getSaplingStack();
        if (sapling.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(BonsaiCache.BONSAI_BY_ITEM.get(sapling.getItem()));
    }

    public int getRequiredGrowTicks() {
        if (this.getBonsaiInfo().isEmpty()) {
            return 0;
        }
        return this.getBonsaiInfo().get().baseTicks();
    }

    public float getTreeGrowthProgress(float partialTicks) {
        if (this.getRequiredGrowTicks() == 0) {
            return 0.0f;
        }
        float progress = (partialTicks + (float)this.growTicks) / (float)this.getRequiredGrowTicks();
        return Math.max(Math.min(progress, 1.0f), 0.0f);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("growTicks", this.growTicks);
        if (!this.lootQueue.isEmpty()) {
            ListTag lootList = new ListTag();
            for (ItemStack stack : this.lootQueue) {
                if (stack.isEmpty()) continue;
                lootList.add((Object)stack.save(provider));
            }
            compoundTag.put("lootQueue", (Tag)lootList);
        }
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.growTicks = compoundTag.getInt("growTicks");
        this.lootQueue.clear();
        ListTag lootList = compoundTag.getList("lootQueue", 10);
        for (Tag lootEntry : lootList) {
            Optional stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)lootEntry);
            if (stack.isPresent()) {
                this.lootQueue.add((ItemStack)stack.get());
                continue;
            }
            BonsaiTrees.LOGGER.warn("Failed to parse ItemStack in Loot Queue from NBT: " + String.valueOf(lootEntry));
        }
    }
}

