/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.client;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlock;
import com.davenonymous.bonsaitrees.client.PotModel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockFakeLevel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockModel;
import com.davenonymous.bonsaitrees.datacomponents.CamouflageDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SaplingDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SoilDataComponent;
import com.davenonymous.bonsaitrees.setup.ModBlocks;
import com.davenonymous.bonsaitrees.setup.ModDataComponents;
import com.davenonymous.bonsaitrees.setup.ModModelLoaders;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BonsaiPotItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Map<ResourceLocation, VertexBuffer> vboMap = new HashMap<ResourceLocation, VertexBuffer>();

    public BonsaiPotItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource pBufferSource, int packedLight, int packedOverlay) {
        SaplingDataComponent saplingData;
        BonsaiInfo info;
        ResourceLocation modelId;
        ResourceLocation camouflageId;
        Block block;
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        BlockState potState = ((Block)ModBlocks.BONSAI_POT.get()).defaultBlockState();
        if (stack.is(((Block)ModBlocks.BONSAI_POT_SMALL.get()).asItem())) {
            potState = ((Block)ModBlocks.BONSAI_POT_SMALL.get()).defaultBlockState();
        }
        BakedModel potModel = modelManager.getBlockModelShaper().getBlockModel(potState);
        Vec3 treeOffset = new Vec3(0.0, 0.0, 0.0);
        float treeMaxScale = 1.0f;
        if (potModel instanceof PotModel) {
            PotModel pot = (PotModel)potModel;
            treeOffset = pot.treeOffset;
            treeMaxScale = pot.treeScale;
        }
        BlockState soilState = null;
        Fluid soilFluid = null;
        ModelData.Builder modelData = ModelData.builder();
        if (stack.has((DataComponentType)ModDataComponents.SOIL_COMPONENT.get())) {
            Item item;
            ItemStack soilStack = ((SoilDataComponent)stack.get((DataComponentType)ModDataComponents.SOIL_COMPONENT.get())).soil();
            if (!soilStack.isEmpty() && (item = soilStack.getItem()) instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                modelData.with(BonsaiPotBlock.SOIL, (Object)item2.getBlock());
                soilState = item2.getBlock().defaultBlockState();
            }
            if (!soilStack.isEmpty() && (item = soilStack.getItem()) instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                modelData.with(BonsaiPotBlock.FLUID_SOIL, (Object)bucket.content);
                soilFluid = bucket.content;
            }
            if (!soilStack.isEmpty() && SoilCache.SOIL_BY_ITEM.containsKey(soilStack.getItem())) {
                modelData.with(BonsaiPotBlock.ITEM_SOIL, (Object)soilStack.getItem());
            }
        }
        if (stack.has((DataComponentType)ModDataComponents.CAMOUFLAGE_COMPONENT.get()) && (block = (Block)BuiltInRegistries.BLOCK.get(camouflageId = ((CamouflageDataComponent)stack.get((DataComponentType)ModDataComponents.CAMOUFLAGE_COMPONENT.get())).camouflage())) != null) {
            modelData.with(BonsaiPotBlock.CAMOUFLAGE, (Object)block);
        }
        ModelData data = modelData.build();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (potModel.getTransforms().hasTransform(displayContext)) {
            ItemTransform transform = potModel.getTransforms().getTransform(displayContext);
            transform.apply(false, poseStack);
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        int tintColor = 0xFFFFFF;
        if (soilState != null) {
            tintColor = Minecraft.getInstance().getBlockColors().getColor(soilState, null, null, 0);
        }
        if (soilFluid != null) {
            tintColor = IClientFluidTypeExtensions.of((Fluid)soilFluid).getTintColor();
        }
        float r = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(tintColor & 0xFF) / 255.0f;
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), pBufferSource.getBuffer(RenderType.solid()), potState, potModel, r, g, b, packedLight, packedOverlay, data, RenderType.translucent());
        if (stack.has((DataComponentType)ModDataComponents.SAPLING_COMPONENT.get()) && (modelId = (info = BonsaiCache.BONSAI_BY_RESOURCE.get((saplingData = (SaplingDataComponent)stack.get((DataComponentType)ModDataComponents.SAPLING_COMPONENT.get())).sapling())).model()) != null && ModModelLoaders.MODEL_MAP.containsKey(modelId)) {
            MultiBlockFakeLevel level;
            MultiBlockModel multiBlockModel;
            VertexBuffer vertexBuffer;
            ModelResourceLocation model = ModModelLoaders.MODEL_MAP.get(modelId);
            BakedModel bakedModel = Minecraft.getInstance().getModelManager().getModel(model);
            if (bakedModel instanceof MultiBlockModel && (vertexBuffer = ModModelLoaders.getVbo(modelId, multiBlockModel = (MultiBlockModel)bakedModel, level = new MultiBlockFakeLevel(multiBlockModel, (BlockAndTintGetter)Minecraft.getInstance().level, Minecraft.getInstance().player.blockPosition()), Minecraft.getInstance().player.blockPosition())) != null && !vertexBuffer.isInvalid()) {
                vertexBuffer.bind();
                poseStack.pushPose();
                poseStack.translate(treeOffset.x / 16.0, treeOffset.y / 16.0, treeOffset.z / 16.0);
                poseStack.scale(treeMaxScale, treeMaxScale, treeMaxScale);
                Matrix4f modelMatrix = poseStack.last().pose();
                Matrix4f viewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
                viewMatrix.mul((Matrix4fc)modelMatrix);
                ModModelLoaders.renderTypeForModels.setupRenderState();
                ShaderInstance shader = RenderSystem.getShader();
                shader.setDefaultUniforms(VertexFormat.Mode.QUADS, viewMatrix, RenderSystem.getProjectionMatrix(), Minecraft.getInstance().getWindow());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setupShaderLights((ShaderInstance)shader);
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                shader.apply();
                Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
                vertexBuffer.drawWithShader(viewMatrix, projectionMatrix, shader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                shader.clear();
                VertexBuffer.unbind();
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }
}

