/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.client;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.client.PotModelGeometry;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.LinkedList;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

public class PotModelLoader
implements IGeometryLoader<PotModelGeometry> {
    public static final PotModelLoader INSTANCE = new PotModelLoader();
    public static final ResourceLocation ID = BonsaiTrees.resource("potmodel");

    private PotModelLoader() {
    }

    public PotModelGeometry read(JsonObject jsonObject, JsonDeserializationContext context) throws JsonParseException {
        Object object;
        JsonObject soilObj;
        JsonElement x2;
        JsonElement jsonElement;
        jsonObject.remove("loader");
        BlockModel base = (BlockModel)context.deserialize((JsonElement)jsonObject, BlockModel.class);
        Vec3 offset = new Vec3(0.0, 0.0, 0.0);
        float scale = 1.0f;
        if (jsonObject.has("tree") && (jsonElement = jsonObject.get("tree")) instanceof JsonObject) {
            JsonElement jsonElement2;
            JsonObject treeJson = (JsonObject)jsonElement;
            if (treeJson.has("offset") && (jsonElement2 = treeJson.get("offset")) instanceof JsonObject) {
                JsonObject offsetJson = (JsonObject)jsonElement2;
                float x2 = offsetJson.has("x") ? offsetJson.get("x").getAsFloat() : 0.0f;
                float y = offsetJson.has("y") ? offsetJson.get("y").getAsFloat() : 0.0f;
                float z = offsetJson.has("z") ? offsetJson.get("z").getAsFloat() : 0.0f;
                offset = new Vec3((double)x2, (double)y, (double)z);
            }
            if (treeJson.has("scale")) {
                scale = treeJson.get("scale").getAsFloat();
            }
        }
        LinkedList<PotModelGeometry.SoilElement> soilElements = new LinkedList<PotModelGeometry.SoilElement>();
        if (jsonObject.has("soil") && (x2 = jsonObject.get("soil")) instanceof JsonObject && (soilObj = (JsonObject)x2).has("faces") && (object = soilObj.get("faces")) instanceof JsonArray) {
            JsonArray soilElementList = (JsonArray)object;
            for (JsonElement jsonEntry : soilElementList) {
                if (!(jsonEntry instanceof JsonObject)) continue;
                JsonObject soilElementJson = (JsonObject)jsonEntry;
                Vec3 from = this.getVec3(soilElementJson, "from");
                Vec3 to = this.getVec3(soilElementJson, "to");
                soilElements.add(new PotModelGeometry.SoilElement(from, to));
            }
        }
        return new PotModelGeometry(base, offset, scale, soilElements);
    }

    private Vec3 getVec3(JsonObject json, String memberName) {
        JsonArray jsonarray = GsonHelper.getAsJsonArray((JsonObject)json, (String)memberName);
        if (jsonarray.size() != 3) {
            throw new JsonParseException("Expected 3 " + memberName + " values, found: " + jsonarray.size());
        }
        double[] value = new double[3];
        for (int i = 0; i < value.length; ++i) {
            value[i] = GsonHelper.convertToDouble((JsonElement)jsonarray.get(i), (String)(memberName + "[" + i + "]"));
        }
        return new Vec3(value[0], value[1], value[2]);
    }
}

