/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.compatibility.jei;

import com.davenonymous.bonsaitrees.datacomponents.CamouflageDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SaplingDataComponent;
import com.davenonymous.bonsaitrees.datacomponents.SoilDataComponent;
import com.davenonymous.bonsaitrees.setup.ModDataComponents;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BonsaiSubtypeInterpreter
implements ISubtypeInterpreter<ItemStack> {
    @Nullable
    public Object getSubtypeData(ItemStack ingredient, UidContext context) {
        SaplingDataComponent property = (SaplingDataComponent)ingredient.get((DataComponentType)ModDataComponents.SAPLING_COMPONENT.get());
        SoilDataComponent soilProperty = (SoilDataComponent)ingredient.get((DataComponentType)ModDataComponents.SOIL_COMPONENT.get());
        CamouflageDataComponent camouflageProperty = (CamouflageDataComponent)ingredient.get((DataComponentType)ModDataComponents.CAMOUFLAGE_COMPONENT.get());
        return new BonsaiSubtypeData(property, soilProperty, camouflageProperty);
    }

    public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
        return this.getSubtypeData(ingredient, context).toString();
    }

    record BonsaiSubtypeData(SaplingDataComponent sapling, SoilDataComponent soil, CamouflageDataComponent camouflage) {
        @Override
        public String toString() {
            return String.format("sapling=%s, soil=%s, camouflage=%s", this.sapling.sapling().toString(), this.soil.soil().toString(), this.camouflage.camouflage().toString());
        }
    }
}

