/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import org.lwjgl.system.MemoryUtil;

public class DynamicImageResources {
    private static Map<String, DynTexture> modLogos = new HashMap<String, DynTexture>();

    public static Optional<DynTexture> getImage(String path, byte[] bytes) {
        try {
            ByteBuffer bb = MemoryUtil.memAlloc((int)bytes.length);
            bb.put(bytes);
            bb.rewind();
            NativeImage logo = NativeImage.read((ByteBuffer)bb);
            TextureManager tm = Minecraft.getInstance().getTextureManager();
            ResourceLocation resource = tm.register("modimage_" + path.hashCode(), new DynamicTexture(logo){

                public void upload() {
                    this.bind();
                    NativeImage td = this.getPixels();
                    this.getPixels().upload(0, 0, 0, 0, 0, td.getWidth(), td.getHeight(), false, false, false, false);
                }
            });
            return Optional.of(new DynTexture(resource, logo));
        }
        catch (Exception e) {
            BonsaiTrees.LOGGER.warn("Failed to read image from {}: {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<DynTexture> getImage(Path path, InputStream inputStream) {
        try {
            NativeImage logo = NativeImage.read((InputStream)inputStream);
            TextureManager tm = Minecraft.getInstance().getTextureManager();
            ResourceLocation resource = tm.register("modimage_" + path.toString(), new DynamicTexture(logo){

                public void upload() {
                    this.bind();
                    NativeImage td = this.getPixels();
                    this.getPixels().upload(0, 0, 0, 0, 0, td.getWidth(), td.getHeight(), false, false, false, false);
                }
            });
            return Optional.of(new DynTexture(resource, logo));
        }
        catch (IOException e) {
            BonsaiTrees.LOGGER.warn("Failed to read image from {}: {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    public static Optional<DynTexture> getModLogo(final IModInfo modInfo) {
        String modId = modInfo.getModId();
        if (modLogos.containsKey(modId)) {
            return Optional.of(modLogos.get(modId));
        }
        Optional logoFile = modInfo.getLogoFile();
        if (logoFile.isEmpty()) {
            return Optional.empty();
        }
        Optional optPack = ResourcePackLoader.getPackFor((String)modInfo.getModId());
        if (optPack.isEmpty()) {
            return Optional.empty();
        }
        Pack.ResourcesSupplier resourcePack = (Pack.ResourcesSupplier)optPack.get();
        TextureManager tm = Minecraft.getInstance().getTextureManager();
        try (PackResources packResources = resourcePack.openPrimary(new PackLocationInfo("mod/" + modInfo.getModId(), (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty()));){
            NativeImage logo = null;
            IoSupplier logoResource = packResources.getRootResource(((String)logoFile.get()).split("[/\\\\]"));
            if (logoResource != null) {
                logo = NativeImage.read((InputStream)((InputStream)logoResource.get()));
            }
            if (logo != null) {
                ResourceLocation resource = tm.register("modlogo_" + modInfo.getModId(), new DynamicTexture(logo){

                    public void upload() {
                        this.bind();
                        NativeImage td = this.getPixels();
                        this.getPixels().upload(0, 0, 0, 0, 0, td.getWidth(), td.getHeight(), modInfo.getLogoBlur(), false, false, false);
                    }
                });
                modLogos.put(modId, new DynTexture(resource, logo));
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
        return Optional.ofNullable(modLogos.get(modId));
    }

    public record DynTexture(ResourceLocation resource, NativeImage image) {
    }
}

