/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class GUIHelper {
    public static ResourceLocation tabIcons = BonsaiTrees.resource("textures/gui/tabicons.png");

    public static int longestWrappedLine(Font font, FormattedText text, int lineWidth) {
        int longest = 0;
        for (FormattedCharSequence formattedcharsequence : font.split(text, lineWidth)) {
            longest = Math.max(longest, font.width(formattedcharsequence));
        }
        return longest;
    }

    public static void drawWordWrap(GuiGraphics pGuiGraphics, Font font, FormattedText text, int x, int y, int lineWidth, int color) {
        for (FormattedCharSequence formattedcharsequence : font.split(text, lineWidth)) {
            pGuiGraphics.drawString(font, formattedcharsequence, x, y, color, false);
            y += 10;
        }
    }

    public static int wordWrapHeight(Font font, FormattedText text, int maxWidth) {
        return 10 * font.split(text, maxWidth).size();
    }

    public static void drawStringCentered(GuiGraphics pGuiGraphics, String str, Screen screen, float x, float y, int color) {
        Font renderer = screen.getMinecraft().font;
        float xPos = x - (float)renderer.width(str) / 2.0f;
        ShaderInstance old = RenderSystem.getShader();
        pGuiGraphics.drawCenteredString(renderer, str, (int)xPos, (int)y, color);
        RenderSystem.setShader(() -> old);
    }

    public static void drawSplitStringCentered(GuiGraphics pGuiGraphics, String str, Screen screen, int x, int y, int width, int color) {
        Font renderer = screen.getMinecraft().font;
        int yOffset = 0;
        for (FormattedText row : renderer.getSplitter().splitLines(str, width, Style.EMPTY)) {
            GUIHelper.drawStringCentered(pGuiGraphics, row.getString(), screen, x + width / 2, y + yOffset, color);
            Objects.requireNonNull(renderer);
            yOffset += 9;
        }
    }

    public static void drawColoredRectangle(GuiGraphics pGuiGraphics, int x, int y, int width, int height, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        GUIHelper.drawColoredRectangle(pGuiGraphics, x, y, width, height, r, g, b, a);
    }

    public static void drawColoredRectangle(GuiGraphics pGuiGraphics, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        float zLevel = 0.0f;
    }

    public static void drawStretchedTabIconsTexture(GuiGraphics pGuiGraphics, int x, int y, int width, int height, int textureX, int textureY, int textureWidth, int textureHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        float zLevel = 0.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = pGuiGraphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)textureX * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)textureY * 0.00390625f);
        builder.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)textureX * 0.00390625f, (float)textureY * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawStretchedTexture(GuiGraphics pGuiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureWidth, int textureHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        float zLevel = 0.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = pGuiGraphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)textureX * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)textureY * 0.00390625f);
        builder.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)textureX * 0.00390625f, (float)textureY * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawModalRectWithCustomSizedTexture(GuiGraphics pGuiGraphics, int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = pGuiGraphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setUv(u * f, (v + (float)height) * f1);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setUv((u + (float)width) * f, (v + (float)height) * f1);
        builder.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setUv((u + (float)width) * f, v * f1);
        builder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(u * f, v * f1);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void renderGuiItem(GuiGraphics pGuiGraphics, ItemStack pStack, int pX, int pY, boolean blackOut) {
        boolean flag;
        BakedModel pBakedmodel = Minecraft.getInstance().getItemRenderer().getModel(pStack, null, null, 0);
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = pGuiGraphics.pose();
        posestack.pushPose();
        posestack.translate((double)pX, (double)pY, 100.0);
        posestack.translate(8.0, 8.0, 0.0);
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !pBakedmodel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        Minecraft.getInstance().getItemRenderer().render(pStack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, blackOut ? 0 : 0xF000F0, OverlayTexture.NO_OVERLAY, pBakedmodel);
        multibuffersource$buffersource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void fillAreaWithIcon(GuiGraphics pGuiGraphics, TextureAtlasSprite icon, int x, int y, int width, int height) {
        int xNow;
        int yNow;
        Tesselator t = Tesselator.getInstance();
        BufferBuilder b = t.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float zLevel = 0.0f;
        int iconWidth = icon.contents().width();
        int iconHeight = icon.contents().height();
        int fullCols = width / iconWidth;
        int fullRows = height / iconHeight;
        float minU = icon.getU0();
        float maxU = icon.getU1();
        float minV = icon.getV0();
        float maxV = icon.getV1();
        int excessWidth = width % iconWidth;
        int excessHeight = height % iconHeight;
        float partialMaxU = minU + (maxU - minU) * ((float)excessWidth / (float)iconWidth);
        float partialMaxV = minV + (maxV - minV) * ((float)excessHeight / (float)iconHeight);
        for (int row = 0; row < fullRows; ++row) {
            yNow = y + row * iconHeight;
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                GUIHelper.drawRect(pGuiGraphics, xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
            }
            if (excessWidth == 0) continue;
            xNow = x + fullCols * iconWidth;
            GUIHelper.drawRect(pGuiGraphics, xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
        }
        if (excessHeight != 0) {
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                yNow = y + fullRows * iconHeight;
                GUIHelper.drawRect(pGuiGraphics, xNow, yNow, iconWidth, excessHeight, zLevel, minU, minV, maxU, partialMaxV);
            }
            if (excessWidth != 0) {
                xNow = x + fullCols * iconWidth;
                yNow = y + fullRows * iconHeight;
                GUIHelper.drawRect(pGuiGraphics, xNow, yNow, excessWidth, excessHeight, zLevel, minU, minV, partialMaxU, partialMaxV);
            }
        }
        b.build();
    }

    private static void drawRect(GuiGraphics pGuiGraphics, float x, float y, float width, float height, float z, float u, float v, float maxU, float maxV) {
        BufferBuilder b = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        b.addVertex(x, y + height, z).setUv(u, maxV);
        b.addVertex(x + width, y + height, z).setUv(maxU, maxV);
        b.addVertex(x + width, y, z).setUv(maxU, v);
        b.addVertex(x, y, z).setUv(u, v);
        b.build();
    }

    public static void drawEmbossedWindow(GuiGraphics pGuiGraphics, ResourceLocation texture, int pWidth, int pHeight) {
        GUIHelper.drawEmbossedWindow(pGuiGraphics, texture, pWidth, pHeight, 0, 0);
    }

    public static void drawEmbossedWindow(GuiGraphics pGuiGraphics, ResourceLocation texture, int pWidth, int pHeight, int x, int y) {
        boolean texOffsetY = false;
        boolean texOffsetX = false;
        int borderSize = 8;
        int width = pWidth;
        int xOffset = x;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        pGuiGraphics.blit(texture, x, y, borderSize, borderSize, 0.0f, 0.0f, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + width - borderSize, y, borderSize, borderSize, 64.0f - (float)borderSize, 0.0f, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x, y + pHeight - borderSize, borderSize, borderSize, 0.0f, 64.0f - (float)borderSize, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + width - borderSize, y + pHeight - borderSize, borderSize, borderSize, 64.0f - (float)borderSize, 64.0f - (float)borderSize, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + 4, y, width - borderSize, borderSize, 0.0f + (float)borderSize, 0.0f, 52, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + 4, y + pHeight - borderSize, width - borderSize, borderSize, 0.0f + (float)borderSize, 64.0f - (float)borderSize, 52, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x, y + borderSize, borderSize, pHeight - 2 * borderSize, 0.0f, (float)borderSize, borderSize, 8, 64, 64);
        pGuiGraphics.blit(texture, x + width - borderSize, y + borderSize, borderSize, pHeight - 2 * borderSize, (float)(64 - borderSize), (float)borderSize, borderSize, 8, 64, 64);
        pGuiGraphics.blit(texture, x + borderSize, y + borderSize, pWidth - 2 * borderSize, pHeight - 2 * borderSize, (float)borderSize, (float)borderSize, 52, 52, 64, 64);
    }

    public static void drawWindow(GuiGraphics pGuiGraphics, int pWidth, int pHeight, boolean hasTabs) {
        GUIHelper.drawWindow(pGuiGraphics, pWidth, pHeight, hasTabs, 0, 0);
    }

    public static void drawWindow(GuiGraphics pGuiGraphics, int pWidth, int pHeight, boolean hasTabs, int x, int y) {
        int texOffsetY = 11;
        int texOffsetX = 64;
        int width = pWidth;
        int xOffset = x;
        if (hasTabs) {
            width -= 32;
            xOffset += 32;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        pGuiGraphics.blit(tabIcons, xOffset, y, texOffsetX, texOffsetY, 4, 4);
        pGuiGraphics.blit(tabIcons, xOffset + width - 4, y, texOffsetX + 4 + 64, texOffsetY, 4, 4);
        pGuiGraphics.blit(tabIcons, xOffset, y + pHeight - 4, texOffsetX, texOffsetY + 4 + 64, 4, 4);
        pGuiGraphics.blit(tabIcons, xOffset + width - 4, y + pHeight - 4, texOffsetX + 4 + 64, texOffsetY + 4 + 64, 4, 4);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + 4, y, width - 8, 4, texOffsetX + 4, texOffsetY, 64, 4);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + 4, y + pHeight - 4, width - 8, 4, texOffsetX + 4, texOffsetY + 4 + 64, 64, 4);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset, y + 4, 4, pHeight - 8, texOffsetX, texOffsetY + 4, 4, 64);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + width - 4, y + 4, 4, pHeight - 8, texOffsetX + 64 + 4, texOffsetY + 3, 4, 64);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + 4, y + 4, width - 8, pHeight - 8, texOffsetX + 4, texOffsetY + 4, 64, 64);
    }
}

