/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.tooltip;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class ItemStackTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final ItemStack stack;
    private boolean showLabel = true;
    private ChatFormatting labelColor = ChatFormatting.GRAY;

    public ItemStackTooltipComponent(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemStackTooltipComponent setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        return this;
    }

    public ItemStackTooltipComponent setLabelColor(ChatFormatting labelColor) {
        this.labelColor = labelColor;
        return this;
    }

    public int getHeight() {
        return 16;
    }

    public int getWidth(Font font) {
        if (!this.showLabel) {
            return 16;
        }
        return 19 + font.width((FormattedText)this.stack.getHoverName());
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.renderItem(this.stack, x, y);
        guiGraphics.renderItemDecorations(font, this.stack, x, y);
        if (this.showLabel) {
            guiGraphics.drawString(font, this.stack.getHoverName(), x + 19, y + 4, this.labelColor.getColor().intValue());
        }
    }
}

