/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.tooltip;

import com.davenonymous.bonsaitrees.lib.gui.tooltip.BoxAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class VBoxTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final List<TooltipComponent> components = new ArrayList<TooltipComponent>();
    private int padding = 0;
    private BoxAlignment alignment = BoxAlignment.START;

    public VBoxTooltipComponent(TooltipComponent ... components) {
        this.components.addAll(Arrays.asList(components));
    }

    public VBoxTooltipComponent add(TooltipComponent ... component) {
        this.components.addAll(Arrays.asList(component));
        return this;
    }

    public VBoxTooltipComponent setAlignment(BoxAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public VBoxTooltipComponent setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public int count() {
        return this.components.size();
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public VBoxTooltipComponent clear() {
        this.components.clear();
        return this;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int currentY = y;
        int maxWidth = this.getWidth(font);
        for (TooltipComponent component : this.components) {
            if (!(component instanceof ClientTooltipComponent)) continue;
            ClientTooltipComponent clientComponent = (ClientTooltipComponent)component;
            int xOffset = x;
            int componentHeight = clientComponent.getWidth(font);
            if (this.alignment == BoxAlignment.CENTER) {
                xOffset += (maxWidth - componentHeight) / 2;
            } else if (this.alignment == BoxAlignment.END) {
                xOffset += maxWidth - componentHeight;
            }
            clientComponent.renderImage(font, xOffset, currentY, guiGraphics);
            currentY += clientComponent.getHeight() + this.padding;
        }
    }

    public int getHeight() {
        int sum = 0;
        for (TooltipComponent component : this.components) {
            if (!(component instanceof ClientTooltipComponent)) continue;
            ClientTooltipComponent clientComponent = (ClientTooltipComponent)component;
            sum += clientComponent.getHeight() + this.padding;
        }
        return sum;
    }

    public int getWidth(Font font) {
        int max = 0;
        for (TooltipComponent component : this.components) {
            if (!(component instanceof ClientTooltipComponent)) continue;
            ClientTooltipComponent clientComponent = (ClientTooltipComponent)component;
            max = Math.max(max, clientComponent.getWidth(font));
        }
        return max;
    }
}

