/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.tooltip;

import com.davenonymous.bonsaitrees.lib.gui.GUIHelper;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.SerializableTooltipComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record WrappedStringTooltipComponent(String message, int color, int maxWidth) implements SerializableTooltipComponent<WrappedStringTooltipComponent>
{
    public static final StreamCodec<FriendlyByteBuf, WrappedStringTooltipComponent> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, WrappedStringTooltipComponent::message, (StreamCodec)ByteBufCodecs.INT, WrappedStringTooltipComponent::color, (StreamCodec)ByteBufCodecs.INT, WrappedStringTooltipComponent::maxWidth, WrappedStringTooltipComponent::new);

    public static WrappedStringTooltipComponent warn(String message) {
        return WrappedStringTooltipComponent.warn(message, Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2);
    }

    public static WrappedStringTooltipComponent warn(String message, int maxWidth) {
        return new WrappedStringTooltipComponent(message, -4896953, maxWidth);
    }

    public static WrappedStringTooltipComponent white(String message) {
        return WrappedStringTooltipComponent.white(message, Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2);
    }

    public static WrappedStringTooltipComponent white(String message, int maxWidth) {
        return new WrappedStringTooltipComponent(message, ChatFormatting.WHITE.getColor(), maxWidth);
    }

    public static WrappedStringTooltipComponent gray(String message) {
        return WrappedStringTooltipComponent.gray(message, Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2);
    }

    public static WrappedStringTooltipComponent gray(String message, int maxWidth) {
        return new WrappedStringTooltipComponent(message, ChatFormatting.GRAY.getColor(), maxWidth);
    }

    public static WrappedStringTooltipComponent yellow(String message) {
        return WrappedStringTooltipComponent.yellow(message, Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2);
    }

    public static WrappedStringTooltipComponent yellow(String message, int maxWidth) {
        return new WrappedStringTooltipComponent(message, ChatFormatting.YELLOW.getColor(), maxWidth);
    }

    public int getHeight() {
        return GUIHelper.wordWrapHeight(Minecraft.getInstance().font, FormattedText.of((String)this.message), this.maxWidth);
    }

    public int getWidth(Font font) {
        return GUIHelper.longestWrappedLine(font, FormattedText.of((String)this.message), this.maxWidth);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        GUIHelper.drawWordWrap(guiGraphics, font, FormattedText.of((String)this.message), x, y, this.maxWidth, this.color);
    }

    @Override
    public StreamCodec<FriendlyByteBuf, WrappedStringTooltipComponent> getCodec() {
        return CODEC;
    }
}

