/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.widgets;

import com.davenonymous.bonsaitrees.lib.gui.event.MouseClickEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseEnterEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.MouseExitEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.WidgetEventResult;
import com.davenonymous.bonsaitrees.lib.gui.widgets.Widget;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class WidgetButton
extends Widget {
    public boolean hovered = false;
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    public Component label;
    public String fixedLabel;
    protected Style style = Style.EMPTY;

    private WidgetButton() {
        this.setHeight(20);
        this.setWidth(100);
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public WidgetButton(Component label) {
        this();
        this.label = label;
    }

    public WidgetButton(String label) {
        this();
        this.fixedLabel = label;
    }

    public WidgetButton setStyle(Function<Style, Style> style) {
        this.style = style.apply(this.style);
        return this;
    }

    public void autoWidth() {
        String toDraw = this.fixedLabel != null ? this.fixedLabel : I18n.get((String)this.label.getString(), (Object[])new Object[0]);
        this.setWidth(Minecraft.getInstance().font.width(FormattedText.of((String)toDraw, (Style)this.style)) + 10);
    }

    public WidgetButton setLabel(Component label) {
        this.label = label;
        return this;
    }

    public WidgetButton setLabel(String label) {
        this.fixedLabel = label;
        return this;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        pGuiGraphics.blitSprite(SPRITES.get(this.enabled, this.isHovered()), 0, 0, this.width, this.height);
        pGuiGraphics.pose().pushPose();
        Font fontrenderer = screen.getMinecraft().font;
        pGuiGraphics.pose().translate(0.0f, 0.0f, 10.0f);
        this.drawButtonContent(pGuiGraphics, screen, fontrenderer);
        pGuiGraphics.pose().translate(0.0f, 0.0f, -10.0f);
        pGuiGraphics.pose().popPose();
    }

    protected void drawButtonContent(GuiGraphics pGuiGraphics, Screen screen, Font renderer) {
        this.drawString(pGuiGraphics, screen, renderer);
    }

    protected void drawString(GuiGraphics pGuiGraphics, Screen screen, Font renderer) {
        int color = 0xFFFFFF;
        String toDraw = this.fixedLabel != null ? this.fixedLabel : I18n.get((String)this.label.getString(), (Object[])new Object[0]);
        pGuiGraphics.drawCenteredString(screen.getMinecraft().font, toDraw, (int)((float)this.width / 2.0f), (int)((float)(this.height - 8) / 2.0f), color);
    }
}

