/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.widgets;

import com.davenonymous.bonsaitrees.lib.gui.GUIHelper;
import com.davenonymous.bonsaitrees.lib.gui.widgets.Widget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class WidgetTextBox
extends Widget {
    private String text;
    private int textColor = 0xFFFFFF;
    private boolean dropShadow = false;
    private boolean wordWrap = false;
    protected Style style = Style.EMPTY;

    public WidgetTextBox(String text) {
        this.text = text;
        this.setWidth(100);
        this.setHeight(9);
    }

    public WidgetTextBox(String text, int textColor) {
        this.text = text;
        this.textColor = textColor;
        this.setWidth(100);
        this.setHeight(9);
    }

    public void autoWidth() {
        this.setWidth(Minecraft.getInstance().font.width(FormattedText.of((String)this.text, (Style)this.style)) + 2);
    }

    public void autoWidth(int maxWidth) {
        this.setWidth(Math.min(Minecraft.getInstance().font.width(FormattedText.of((String)this.text, (Style)this.style)) + 2, maxWidth));
    }

    public WidgetTextBox setStyle(Function<Style, Style> style) {
        this.style = style.apply(this.style);
        return this;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public WidgetTextBox setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
    }

    public boolean getDropShadow() {
        return this.dropShadow;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        if (this.text == null) {
            return;
        }
        pGuiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        int scale = WidgetTextBox.computeGuiScale(screen.getMinecraft());
        int bottomOffset = (int)(((double)(screen.getMinecraft().getWindow().getHeight() / scale) - (double)(this.getActualY() + this.height)) * (double)scale);
        int heightTmp = this.height * scale - 1;
        if (heightTmp < 0) {
            heightTmp = 0;
        }
        RenderSystem.enableScissor((int)(this.getActualX() * scale - 3), (int)(bottomOffset + 2), (int)(this.width * scale), (int)heightTmp);
        if (this.wordWrap) {
            GUIHelper.drawWordWrap(pGuiGraphics, screen.getMinecraft().font, FormattedText.of((String)this.text, (Style)this.style), 0, 0, this.width, this.textColor);
        } else {
            GUIHelper.drawWordWrap(pGuiGraphics, screen.getMinecraft().font, FormattedText.of((String)this.text, (Style)this.style), 0, 0, Integer.MAX_VALUE, this.textColor);
        }
        RenderSystem.disableScissor();
        RenderSystem.disableBlend();
        pGuiGraphics.pose().popPose();
    }
}

