/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup.cache;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.setup.ModDataMaps;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilInfoWithTexture;
import com.davenonymous.bonsaitrees.setup.data.SoilType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;

public class SoilCache {
    public static final Map<Block, Set<SoilInfo>> SOIL_BY_BLOCK = new HashMap<Block, Set<SoilInfo>>();
    public static final Map<Fluid, Set<SoilInfo>> SOIL_BY_FLUID = new HashMap<Fluid, Set<SoilInfo>>();
    public static final Map<Item, Set<SoilInfoWithTexture>> SOIL_BY_ITEM = new HashMap<Item, Set<SoilInfoWithTexture>>();
    public static final Map<ItemStack, Set<SoilInfo>> SOILS = new HashMap<ItemStack, Set<SoilInfo>>();
    public static final Map<ResourceLocation, Map<Item, Set<SoilInfo>>> SOIL_BY_TYPE = new HashMap<ResourceLocation, Map<Item, Set<SoilInfo>>>();
    public static final Map<ResourceLocation, Set<Item>> BONSAIS_BY_SOIL = new HashMap<ResourceLocation, Set<Item>>();

    public static void dataMapsUpdated(DataMapsUpdatedEvent event) {
        Registry blockRegistry = event.getRegistries().registryOrThrow(Registries.BLOCK);
        Registry fluidRegistry = event.getRegistries().registryOrThrow(Registries.FLUID);
        Registry itemRegistry = event.getRegistries().registryOrThrow(Registries.ITEM);
        SOIL_BY_TYPE.clear();
        SOILS.clear();
        SOIL_BY_BLOCK.clear();
        Map blockDataMap = blockRegistry.getDataMap(ModDataMaps.BLOCK_SOIL);
        for (Map.Entry entry : blockDataMap.entrySet()) {
            ResourceKey resourceKey = (ResourceKey)entry.getKey();
            if (!blockRegistry.containsKey(resourceKey)) {
                BonsaiTrees.LOGGER.warn("Block {} is not registered in the block registry, skipping soil registration.", (Object)resourceKey.location());
                continue;
            }
            Block block = (Block)blockRegistry.get(resourceKey);
            Item soilItem = block.asItem();
            SoilInfo soilInfo = (SoilInfo)entry.getValue();
            SOIL_BY_BLOCK.computeIfAbsent(block, k -> new HashSet()).add(soilInfo);
            List<ResourceLocation> types = soilInfo.soilType();
            Iterator<Object> iterator = types.iterator();
            while (iterator.hasNext()) {
                ResourceLocation type = iterator.next();
                Map byTypeMap = SOIL_BY_TYPE.computeIfAbsent(type, k -> new HashMap());
                byTypeMap.computeIfAbsent(soilItem, k -> new HashSet()).add(soilInfo);
            }
            SOILS.computeIfAbsent(new ItemStack((ItemLike)block), k -> new HashSet()).add(soilInfo);
        }
        SOIL_BY_FLUID.clear();
        Map fluidDataMap = fluidRegistry.getDataMap(ModDataMaps.FLUID_SOIL);
        for (Map.Entry entry : fluidDataMap.entrySet()) {
            ResourceKey resourceKey = (ResourceKey)entry.getKey();
            if (!fluidRegistry.containsKey(resourceKey)) {
                BonsaiTrees.LOGGER.warn("Fluid {} is not registered in the fluid registry, skipping soil registration.", (Object)resourceKey.location());
                continue;
            }
            SoilInfo soilInfo = (SoilInfo)entry.getValue();
            SOIL_BY_FLUID.computeIfAbsent((Fluid)fluidRegistry.get(resourceKey), k -> new HashSet()).add(soilInfo);
            List<ResourceLocation> types = soilInfo.soilType();
            for (ResourceLocation type : types) {
                Map byTypeMap = SOIL_BY_TYPE.computeIfAbsent(type, k -> new HashMap());
                byTypeMap.computeIfAbsent(((Fluid)fluidRegistry.get(resourceKey)).getBucket(), k -> new HashSet()).add(soilInfo);
            }
            SOILS.computeIfAbsent(new ItemStack((ItemLike)((Fluid)fluidRegistry.get(resourceKey)).getBucket()), k -> new HashSet()).add(soilInfo);
        }
        SOIL_BY_ITEM.clear();
        Map itemDataMap = itemRegistry.getDataMap(ModDataMaps.ITEM_SOIL);
        for (Map.Entry entry : itemDataMap.entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            if (!itemRegistry.containsKey(key)) {
                BonsaiTrees.LOGGER.warn("Item {} is not registered in the item registry, skipping soil registration.", (Object)key.location());
                continue;
            }
            Item item = (Item)itemRegistry.get(key);
            SoilInfoWithTexture soilInfoWithTexture = (SoilInfoWithTexture)entry.getValue();
            SOIL_BY_ITEM.computeIfAbsent(item, k -> new HashSet()).add(soilInfoWithTexture);
            SoilInfo soilInfo = SoilInfo.fromSoilInfoWithTexture(soilInfoWithTexture);
            List<ResourceLocation> types = soilInfo.soilType();
            for (ResourceLocation type : types) {
                Map byTypeMap = SOIL_BY_TYPE.computeIfAbsent(type, k -> new HashMap());
                byTypeMap.computeIfAbsent(item, k -> new HashSet()).add(soilInfo);
            }
            SOILS.computeIfAbsent(new ItemStack((ItemLike)item), k -> new HashSet()).add(soilInfo);
        }
        BONSAIS_BY_SOIL.clear();
        for (Map.Entry<Item, BonsaiInfo> entry : BonsaiCache.BONSAI_BY_ITEM.entrySet()) {
            Item bonsaiItem = entry.getKey();
            BonsaiInfo bonsaiInfo = entry.getValue();
            List<SoilType> validSoilTypes = bonsaiInfo.validSoilTypes(event.getRegistries());
            for (SoilType soilType : validSoilTypes) {
                if (!BONSAIS_BY_SOIL.containsKey(soilType.id())) {
                    BONSAIS_BY_SOIL.put(soilType.id(), new HashSet());
                }
                BONSAIS_BY_SOIL.get(soilType.id()).add(bonsaiItem);
            }
        }
        BonsaiTrees.LOGGER.debug("Soil-Type Summary:");
        for (ResourceLocation resourceLocation : BONSAIS_BY_SOIL.keySet()) {
            Set<Item> bonsais = BONSAIS_BY_SOIL.get(resourceLocation);
            BonsaiTrees.LOGGER.debug("  {} with {} bonsais", (Object)resourceLocation, (Object)bonsais.size());
        }
    }

    public static boolean isSoil(ItemStack soilStack) {
        return SoilCache.getSoilInfo(soilStack).isPresent();
    }

    public static Optional<Set<SoilInfo>> getSoilInfo(ItemStack soilStack) {
        Item item;
        if (!soilStack.isEmpty() && (item = soilStack.getItem()) instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return Optional.ofNullable(SOIL_BY_BLOCK.get(item2.getBlock()));
        }
        if (!soilStack.isEmpty() && (item = soilStack.getItem()) instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            return Optional.ofNullable(SOIL_BY_FLUID.get(bucket.content));
        }
        if (!soilStack.isEmpty() && SOIL_BY_ITEM.containsKey(soilStack.getItem())) {
            Set<SoilInfoWithTexture> texturedSoilInfos = SOIL_BY_ITEM.get(soilStack.getItem());
            if (texturedSoilInfos == null || texturedSoilInfos.isEmpty()) {
                return Optional.empty();
            }
            Set soilInfos = texturedSoilInfos.stream().map(SoilInfo::fromSoilInfoWithTexture).collect(Collectors.toSet());
            return Optional.of(soilInfos);
        }
        return Optional.empty();
    }
}

