/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.SodiumConsole;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EuphoriaLogger {
    public static Logger logger = LogManager.getLogger((String)"euphoriaPatches");
    private static final String ERROR_LOG_FILE_NAME = "1_EUPHORIA_PATCHES_ERROR_LOGS.txt";
    private final Path errorLogFilePath = EuphoriaPatcher.shaderpacks.resolve("1_EUPHORIA_PATCHES_ERROR_LOGS.txt");
    private boolean isSodiumInstalled = false;
    private boolean shouldCreateErrorLog = true;

    public void checkAndSetupSodiumLogging() {
        this.isSodiumInstalled = SodiumConsole.isSodiumAvailable();
        if (this.isSodiumInstalled) {
            EuphoriaLogger.debugLog("Sodium found, using Sodium logging!");
        }
    }

    public void log(int messageLevel, int messageFadeTimer, String message) {
        String loggingMessage = "EuphoriaPatcher: " + message;
        if (messageLevel == -1) {
            loggingMessage = "\n\n" + loggingMessage + "\n";
        }
        if (this.isSodiumInstalled && messageFadeTimer > 0) {
            SodiumConsole.logMessage(messageLevel, messageFadeTimer, loggingMessage);
        }
        switch (messageLevel) {
            case -1: 
            case 0: 
            case 1: {
                logger.info(loggingMessage);
                break;
            }
            case 2: {
                logger.warn(loggingMessage);
                if (messageFadeTimer <= 0) break;
                this.appendToErrorLogFile("[WARNING] " + loggingMessage);
                break;
            }
            case 3: {
                logger.error(loggingMessage);
                if (messageFadeTimer <= 0) break;
                this.appendToErrorLogFile("[ERROR] " + loggingMessage);
                break;
            }
            default: {
                System.out.println(loggingMessage);
            }
        }
        if (message.contains("Have fun developing Euphoria Patches!") || message.contains("Thank you for using Euphoria Patches - SpacEagle17")) {
            this.deleteErrorLogFile();
        }
    }

    public void log(int messageLevel, String message) {
        int[] fadeTimers = new int[]{0, 4, 8, 16};
        int messageFadeTimer = messageLevel >= 0 && messageLevel < fadeTimers.length ? fadeTimers[messageLevel] : 0;
        this.log(messageLevel, messageFadeTimer, message);
    }

    public void checkErrorLogFileAndAddSeparator() {
        if (!this.shouldCreateErrorLog) {
            return;
        }
        try {
            if (Files.exists(this.errorLogFilePath, new LinkOption[0])) {
                String separator = "\n--------------------------------------\nRestart happened\n--------------------------------------\n";
                Files.write(this.errorLogFilePath, separator.getBytes(), StandardOpenOption.APPEND);
                this.log(0, "Added restart separator to error log file");
            }
        }
        catch (IOException e) {
            this.log(0, "Failed to add restart separator to error log file: " + e.getMessage());
        }
    }

    private void appendToErrorLogFile(String message) {
        if (!this.shouldCreateErrorLog) {
            return;
        }
        try {
            if (!Files.exists(this.errorLogFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.errorLogFilePath.getParent(), new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String logEntry = timestamp + " " + message + System.lineSeparator();
            StandardOpenOption option = Files.exists(this.errorLogFilePath, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE;
            Files.write(this.errorLogFilePath, logEntry.getBytes(), option);
        }
        catch (IOException e) {
            this.log(0, "Failed to write to error log file: " + e.getMessage());
        }
    }

    private void deleteErrorLogFile() {
        try {
            if (Files.exists(this.errorLogFilePath, new LinkOption[0])) {
                Files.delete(this.errorLogFilePath);
                this.log(0, "Deleted error log file as shader was successfully installed");
                this.shouldCreateErrorLog = false;
            }
        }
        catch (IOException e) {
            this.log(0, "Failed to delete error log file: " + e.getMessage());
        }
    }

    public static void debugLog(String message) {
        if (EuphoriaPatcher.doDebugLogging) {
            EuphoriaPatcher.log(0, message);
        }
    }
}

