/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.augmenting;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.augmenting.AugmentingTableTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class AugmentingTableTileRenderer
implements BlockEntityRenderer<AugmentingTableTile> {
    public static final ModelResourceLocation STAR_CUBE = ModelResourceLocation.standalone((ResourceLocation)Apotheosis.loc("item/star_cube"));

    public void render(AugmentingTableTile tile, float partials, PoseStack matrix, MultiBufferSource pBufferSource, int light, int overlay) {
        if (tile.stage == AugmentingTableTile.AnimationStage.HIDING) {
            return;
        }
        Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer irenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel base = irenderer.getItemModelShaper().getModelManager().getModel(STAR_CUBE);
        double px = 0.0625;
        long time = tile.time;
        matrix.pushPose();
        matrix.translate(5.0 * px, 5.0 * px, 5.0 * px);
        switch (tile.stage) {
            case HIDING: {
                break;
            }
            case RISING: {
                float progress = ((float)time + partials) / (float)AugmentingTableTile.RISE_TIME;
                double rise = Mth.lerp((double)progress, (double)(0.1 * px), (double)(11.0 * px));
                matrix.translate(0.0, rise, 0.0);
                break;
            }
            case FALLING: {
                float progress = ((float)((long)AugmentingTableTile.RISE_TIME - time) + partials) / (float)AugmentingTableTile.RISE_TIME;
                double rise = Mth.lerp((double)progress, (double)(11.0 * px), (double)(0.1 * px));
                matrix.translate(0.0, rise, 0.0);
                break;
            }
            case SPINNING: {
                float rotation = ((float)(time % 360L) + partials) * (float)Math.PI / 180.0f;
                matrix.translate(0.0, 11.0 * px, 0.0);
                matrix.translate(3.0 * px, 3.0 * px, 3.0 * px);
                matrix.mulPose(new Quaternionf().rotationXYZ(rotation, 0.0f, rotation));
                matrix.translate(-3.0 * px, -3.0 * px, -3.0 * px);
            }
        }
        irenderer.renderModelLists(base, ItemStack.EMPTY, light, overlay, matrix, ItemRenderer.getFoilBufferDirect((MultiBufferSource)pBufferSource, (RenderType)Sheets.translucentItemSheet(), (boolean)true, (boolean)false));
        matrix.popPose();
    }
}

