/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.RadialUtil;
import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class RadialAffix
extends Affix {
    public static final Codec<RadialAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(RadialAffix.affixDef(), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories), (App)LootRarity.mapCodec(Codec.list(RadialUtil.RadialData.CODEC)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, RadialAffix::new));
    public static final ResourceLocation AFFIX_RADIAL_DATA_CACHED_OBJECT = Apotheosis.loc("afx_radial_data");
    protected final Set<LootCategory> categories;
    protected final Map<LootRarity, List<RadialUtil.RadialData>> values;

    public RadialAffix(AffixDefinition def, Set<LootCategory> categories, Map<LootRarity, List<RadialUtil.RadialData>> values) {
        super(def);
        this.categories = categories;
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return this.categories.contains(cat) && this.values.containsKey(rarity);
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        RadialUtil.RadialData data = this.getTrueLevel(inst);
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{data.x(), data.y()});
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        RadialUtil.RadialData max;
        MutableComponent comp = this.getDescription(inst, ctx);
        RadialUtil.RadialData min = this.getTrueLevel(inst.getRarity(), 0.0f);
        if (min != (max = this.getTrueLevel(inst.getRarity(), 1.0f))) {
            MutableComponent minComp = Component.translatable((String)"%sx%s", (Object[])new Object[]{min.x(), min.y()});
            MutableComponent maxComp = Component.translatable((String)"%sx%s", (Object[])new Object[]{max.x(), max.y()});
            comp.append((Component)RadialAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    public static void onBreak(BlockEvent.BreakEvent e) {
        Player player = e.getPlayer();
        RadialUtil.RadialData data = RadialAffix.getRadialData(player.getMainHandItem());
        if (data != null) {
            RadialUtil.attemptRadialMining(e, data);
        }
    }

    @Nullable
    public static RadialUtil.RadialData getRadialData(ItemStack tool) {
        return (RadialUtil.RadialData)CachedObject.CachedObjectSource.getOrCreate((ItemStack)tool, (ResourceLocation)AFFIX_RADIAL_DATA_CACHED_OBJECT, RadialAffix::getRadialDataImpl, (ToIntFunction)CachedObject.hashComponents((DataComponentType[])new DataComponentType[]{Apoth.Components.AFFIXES}));
    }

    @Nullable
    private static RadialUtil.RadialData getRadialDataImpl(ItemStack tool) {
        AffixInstance inst;
        if (tool.has(Apoth.Components.AFFIXES) && (inst = (AffixInstance)AffixHelper.streamAffixes(tool).filter(i -> i.getAffix() instanceof RadialAffix).findFirst().orElse(null)) != null && inst.isValid()) {
            return ((RadialAffix)inst.getAffix()).getTrueLevel((LootRarity)inst.rarity().get(), inst.level());
        }
        return null;
    }

    private RadialUtil.RadialData getTrueLevel(AffixInstance inst) {
        return this.getTrueLevel(inst.getRarity(), inst.level());
    }

    private RadialUtil.RadialData getTrueLevel(LootRarity rarity, float level) {
        List<RadialUtil.RadialData> list = this.values.get(rarity);
        return list.get(Math.min(list.size() - 1, (int)Mth.lerp((float)level, (float)0.0f, (float)list.size())));
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    @Override
    public boolean isLevelIndependent(AffixInstance inst) {
        return this.values.get(inst.getRarity()).size() == 1;
    }

    public static class Builder
    extends AffixBuilder<Builder> {
        protected final Map<LootRarity, List<RadialUtil.RadialData>> values = new HashMap<LootRarity, List<RadialUtil.RadialData>>();
        protected final Set<LootCategory> categories = new LinkedHashSet<LootCategory>();

        public Builder value(LootRarity rarity, UnaryOperator<DataListBuilder> config) {
            final ArrayList list = new ArrayList();
            config.apply(new DataListBuilder(){

                @Override
                public DataListBuilder radii(int x, int y, int xOffset, int yOffset) {
                    list.add(new RadialUtil.RadialData(x, y, xOffset, yOffset));
                    return this;
                }
            });
            this.values.put(rarity, list);
            return this;
        }

        public Builder categories(LootCategory ... cats) {
            for (LootCategory cat : cats) {
                this.categories.add(cat);
            }
            return this;
        }

        public RadialAffix build() {
            Preconditions.checkNotNull((Object)this.definition);
            Preconditions.checkArgument((this.values.size() > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.categories.size() > 0 ? 1 : 0) != 0);
            return new RadialAffix(this.definition, this.categories, this.values);
        }

        public static interface DataListBuilder {
            public DataListBuilder radii(int var1, int var2, int var3, int var4);

            default public DataListBuilder radii(int x, int y) {
                return this.radii(x, y, 0, 0);
            }
        }
    }
}

