/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.gateways;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AffixItemReward
implements Reward {
    public static final Codec<AffixItemReward> CODEC = RecordCodecBuilder.create((T inst) -> inst.group((App)PlaceboCodecs.setOf((Codec)RarityRegistry.INSTANCE.holderCodec()).optionalFieldOf("rarities", Set.of()).forGetter(a -> a.rarities), (App)PlaceboCodecs.setOf((Codec)AffixLootRegistry.INSTANCE.holderCodec()).optionalFieldOf("entries", Set.of()).forGetter(a -> a.entries)).apply((Applicative)inst, AffixItemReward::new));
    private final Set<DynamicHolder<LootRarity>> rarities;
    private final Set<DynamicHolder<AffixLootEntry>> entries;
    private transient boolean validated = false;

    protected AffixItemReward(Set<DynamicHolder<LootRarity>> rarities, Set<DynamicHolder<AffixLootEntry>> entries) {
        this.rarities = rarities;
        this.entries = entries;
    }

    public Codec<? extends Reward> getCodec() {
        return CODEC;
    }

    public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
        GenContext gCtx;
        ItemStack stack;
        if (!this.validated) {
            this.rarities.forEach(AffixItemReward::checkBound);
            this.entries.forEach(AffixItemReward::checkBound);
            this.validated = true;
        }
        if (!(stack = LootController.createAffixItemFromPools(this.rarities, this.entries, gCtx = GenContext.forPlayer(summoner))).isEmpty()) {
            list.accept(stack);
        }
    }

    public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
        if (this.rarities.isEmpty()) {
            list.accept(Apotheosis.lang("reward", "random_affix_item", new Object[0]));
        } else {
            MutableComponent rarities = this.rarities.stream().filter(DynamicHolder::isBound).map(DynamicHolder::get).map(LootRarity::toComponent).reduce((a, b) -> a.append("/").append((Component)b)).get();
            MutableComponent text = Apotheosis.lang("reward", "affix_item", rarities);
            list.accept(text);
        }
    }

    public static AffixItemReward create(Set<DynamicHolder<LootRarity>> rarities, Set<DynamicHolder<AffixLootEntry>> entries) {
        return new AffixItemReward(rarities, entries);
    }

    @SafeVarargs
    public static AffixItemReward create(DynamicHolder<LootRarity> ... rarities) {
        return new AffixItemReward(ApothMiscUtil.linkedSet(rarities), Set.of());
    }

    public static AffixItemReward create() {
        return new AffixItemReward(Set.of(), Set.of());
    }

    private static void checkBound(DynamicHolder<?> holder) {
        if (!holder.isBound()) {
            Apotheosis.LOGGER.error("An AffixItemReward failed to resolve {}!", (Object)holder.toString());
        }
    }
}

