/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data.gateways;

import com.mojang.serialization.DynamicOps;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.compat.gateways.AffixItemReward;
import dev.shadowsoffire.apotheosis.compat.gateways.AffixWaveModifier;
import dev.shadowsoffire.apotheosis.compat.gateways.EliteWaveEntity;
import dev.shadowsoffire.apotheosis.compat.gateways.GemReward;
import dev.shadowsoffire.apotheosis.compat.gateways.InvaderWaveEntity;
import dev.shadowsoffire.apotheosis.compat.gateways.PassengerWaveModifier;
import dev.shadowsoffire.apotheosis.compat.gateways.TrueRandomGemReward;
import dev.shadowsoffire.apotheosis.compat.gateways.TrueRandomInvaderWaveEntity;
import dev.shadowsoffire.apotheosis.compat.gateways.tiered_gate.TieredGateway;
import dev.shadowsoffire.apotheosis.data.Rarities;
import dev.shadowsoffire.apotheosis.mobs.registries.EliteRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Elite;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.gate.BossEventSettings;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import dev.shadowsoffire.gateways.gate.StandardWaveEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.ApplicationMode;
import dev.shadowsoffire.gateways.gate.endless.EndlessGateway;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.color.GradientColor;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ApothGateProvider
extends DynamicRegistryProvider<Gateway> {
    public ApothGateProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)GatewayRegistry.INSTANCE);
    }

    public String getName() {
        return "Apotheosis Gateways";
    }

    public void generate() {
        this.tieredGateway("tiered/frontier", b -> b.settings(c -> c.tier(WorldTier.FRONTIER).size(Gateway.Size.SMALL).color(0x33FF33).soundtrack(Apoth.Sounds.MUSIC_DISC_SHIMMER)).rules(c -> c.lives(3).requiresNearbyPlayer(true)).wave(w -> w.maxWaveTime(2400).setupTime(100).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.ZOMBIE).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("frontier/iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).addModifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_zombie")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.SKELETON).count(2).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("frontier/ranged/chain"))).addModifier((WaveModifier)AffixWaveModifier.create()).addModifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_skeleton")).build())).wave(w -> w.maxWaveTime(2400).setupTime(160).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.ZOMBIE).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("frontier/iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_zombie")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.SKELETON).count(2).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("frontier/ranged/chain"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_skeleton")).build()).reward((Reward)new Reward.ExperienceReward(350, 25)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.1f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)2.5f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.15f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.15f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.1f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.05f))).wave(w -> w.maxWaveTime(3200).setupTime(160).entity((WaveEntity)InvaderWaveEntity.createRandom(2)).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.ZOMBIE).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("frontier/iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_zombie")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.SKELETON).count(2).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("frontier/ranged/chain"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_skeleton")).build()).reward((Reward)new Reward.ExperienceReward(650, 25)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.15f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)3.5f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.2f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.1f))).keyReward((Reward)new Reward.CountedReward((Reward)AffixItemReward.create(Rarities.UNCOMMON, Rarities.RARE), 3)).keyReward((Reward)new Reward.CountedReward((Reward)GemReward.create(Purity.CHIPPED, Purity.FLAWED), 5)).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.GEM_DUST, 16))).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.UNCOMMON_MATERIAL, 8))).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.SIGIL_OF_SOCKETING, 2))));
        this.tieredGateway("tiered/ascent", b -> b.settings(c -> c.tier(WorldTier.ASCENT).size(Gateway.Size.MEDIUM).color(0x5555FF).soundtrack(Apoth.Sounds.MUSIC_DISC_FLASH)).rules(c -> c.lives(3).requiresNearbyPlayer(true)).wave(w -> w.maxWaveTime(2400).setupTime(100).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.WITCH).count(1).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)12.0f)).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.HUSK).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("ascent/diamond"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_husk")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.STRAY).count(2).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("ascent/ranged/iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_stray")).build()).reward((Reward)new Reward.ExperienceReward(450, 25)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty())).wave(w -> w.maxWaveTime(3200).setupTime(200).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.POLAR_BEAR).count(1).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("ascent/diamond"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_polar_bear")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.WOLF).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("ascent/iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_wolf")).nbt(t -> {
            t.putInt("AngerTime", 9999999);
            return t;
        }).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.BOGGED).count(2).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("ascent/ranged/iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_bogged")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.PHANTOM).count(2).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)6.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.LIFE_STEAL, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.25f)).desc(Apotheosis.langKey("wave_entity", "vampiric_phantom")).build()).reward((Reward)new Reward.ExperienceReward(650, 25)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.2f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)4.0f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.35f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.3f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.1f))).wave(w -> w.maxWaveTime(4800).setupTime(240).entity((WaveEntity)InvaderWaveEntity.createRandom(3)).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.WITHER_SKELETON).count(5).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("gateway_only/nether_herald"))).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)20.0f)).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "nether_herald")).build()).reward((Reward)new Reward.ExperienceReward(850, 25)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)5.0f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.4f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.08f))).keyReward((Reward)new Reward.CountedReward((Reward)AffixItemReward.create(Rarities.RARE, Rarities.EPIC), 3)).keyReward((Reward)new Reward.CountedReward((Reward)GemReward.create(Purity.FLAWED, Purity.NORMAL), 5)).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.GEM_DUST, 24))).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.RARE_MATERIAL, 12))).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.SIGIL_OF_SOCKETING, 2))).keyReward((Reward)new Reward.StackReward(new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 3))));
        this.tieredGateway("tiered/summit", b -> b.settings(c -> c.tier(WorldTier.SUMMIT).size(Gateway.Size.MEDIUM).color(0xBB00BB).soundtrack((Holder<SoundEvent>)Ench.Sounds.MUSIC_DISC_ARCANA)).rules(c -> c.lives(3).requiresNearbyPlayer(true).spawnRange(24.0).leashRange(48.0)).wave(w -> w.maxWaveTime(3000).setupTime(100).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.GHAST).count(3).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)35.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR_TOUGHNESS, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)10.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)12.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.55f)).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.ZOMBIFIED_PIGLIN).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("summit/enchanted_diamond"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_zombified_piglin")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.WITHER_SKELETON).count(2).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("summit/ranged/enchanted_iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_wither_skeleton")).build()).reward((Reward)new Reward.ExperienceReward(1050, 50)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty())).wave(w -> w.maxWaveTime(3200).setupTime(200).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.GHAST).count(2).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)12.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.55f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.SCALE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)-0.75f)).addModifier((WaveModifier)PassengerWaveModifier.create(EntityType.STRAY, c -> c.finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("summit/ranged/enchanted_iron"))).addModifier((WaveModifier)AffixWaveModifier.create()))).desc(Apotheosis.langKey("wave_entity", "ghast_rider")).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.PIGLIN_BRUTE).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("summit/netherite"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_piglin_brute")).nbt(c -> {
            c.putBoolean("IsImmuneToZombification", true);
            return c;
        }).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.STRAY).count(2).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("summit/ranged/enchanted_iron"))).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "affixed_armored_stray")).build()).reward((Reward)new Reward.ExperienceReward(1250, 50)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.2f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)4.0f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.35f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.3f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.1f))).wave(w -> w.maxWaveTime(6400).setupTime(240).entity((WaveEntity)InvaderWaveEntity.createRandom(3)).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.PIGLIN_BRUTE).count(5).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("gateway_only/bastion_guard"))).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)20.0f)).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "bastion_guard")).nbt(c -> {
            c.putBoolean("IsImmuneToZombification", true);
            return c;
        }).build()).reward((Reward)new Reward.ExperienceReward(1550, 50)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)5.0f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.15f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.4f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.08f))).keyReward((Reward)new Reward.CountedReward((Reward)AffixItemReward.create(Rarities.EPIC, Rarities.MYTHIC), 3)).keyReward((Reward)new Reward.CountedReward((Reward)GemReward.create(Purity.NORMAL, Purity.FLAWLESS), 5)).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.GEM_DUST, 48))).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.EPIC_MATERIAL, 24))).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.SIGIL_OF_SOCKETING, 6))).keyReward((Reward)new Reward.StackReward(new ItemStack((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE, 1), Apotheosis.langKey("reward", "netherite_smithing_template"))));
        this.endlessGateway("endless_invader", b -> b.color((TextColor)GradientColor.RAINBOW).size(Gateway.Size.LARGE).bossSettings(new BossEventSettings(BossEventSettings.Mode.NAME_PLATE, false)).spawnAlgo(SpawnAlgorithms.INWARD_SPIRAL).soundtrack(Apoth.Sounds.MUSIC_DISC_GLIMMER).rules(c -> c.lives(3).requiresNearbyPlayer(true).allowDiscarding(true).spacing(32.0)).baseWave(w -> w.maxWaveTime(3600).setupTime(200).entity((WaveEntity)TrueRandomInvaderWaveEntity.createRandom(3)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.4f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROT_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.2f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.02f)).reward((Reward)new Reward.CountedReward((Reward)AffixItemReward.create(Rarities.MYTHIC), 1)).reward((Reward)new Reward.CountedReward((Reward)TrueRandomGemReward.create(Purity.PERFECT), 3)).reward((Reward)new Reward.ExperienceReward(25000, 1000))).modifier(m -> m.applicationMode((ApplicationMode)new ApplicationMode.AfterEveryNWaves(3, 100)).entity((WaveEntity)TrueRandomInvaderWaveEntity.createRandom(1)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.1f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR_TOUGHNESS, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.03f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.25f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.08f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROT_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.08f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.05f)).reward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.MYTHIC_MATERIAL, 16))).reward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.GEM_DUST, 16))).reward((Reward)new Reward.ExperienceReward(25000, 1000)).setupTime(-5).maxWaveTime(-25)).modifier(m -> m.applicationMode((ApplicationMode)new ApplicationMode.OnlyOnEveryNWaves(100)).reward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.SIGIL_OF_SUPREMACY))).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)1.0f))));
        this.tieredGateway("tiered/pinnacle", b -> b.settings(c -> c.tier(WorldTier.PINNACLE).size(Gateway.Size.LARGE).color(15560724).soundtrack((Holder<SoundEvent>)Ench.Sounds.MUSIC_DISC_QUANTA)).rules(c -> c.lives(3).requiresNearbyPlayer(true).spawnRange(24.0).leashRange(48.0)).wave(w -> w.maxWaveTime(3000).setupTime(100).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.ZOMBIE).count(3).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)80.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)12.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.55f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.SCALE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)5.0f)).addModifier((WaveModifier)WaveModifier.EffectModifier.create((Holder)MobEffects.FIRE_RESISTANCE, (int)0, (boolean)true, (boolean)false)).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("pinnacle/enchanted_netherite"))).addModifier((WaveModifier)AffixWaveModifier.create()).addModifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).desc("entity.minecraft.giant").nbt(t -> {
            MutableComponent name = Component.translatable((String)"entity.minecraft.giant");
            t.put("CustomName", (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)name).getOrThrow());
            return t;
        }).build()).reward((Reward)new Reward.ExperienceReward(2000, 100))).wave(w -> w.maxWaveTime(3200).setupTime(200).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.ILLUSIONER).count(2).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR_TOUGHNESS, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)25.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.55f)).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("pinnacle/ranged/enchanted_netherite"))).addModifier((WaveModifier)AffixWaveModifier.create()).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.EVOKER).count(2).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR_TOUGHNESS, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)25.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.55f)).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("pinnacle/ranged/enchanted_netherite"))).addModifier((WaveModifier)AffixWaveModifier.create()).build()).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.RABBIT).count(3).finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)15.0f)).addModifier((WaveModifier)WaveModifier.GearSetModifier.create((ResourceLocation)Apotheosis.loc("pinnacle/enchanted_netherite"))).addModifier((WaveModifier)AffixWaveModifier.create()).addModifier((WaveModifier)AffixWaveModifier.create()).desc(Apotheosis.langKey("wave_entity", "killer_bunny")).nbt(c -> {
            c.putInt("RabbitType", 99);
            return c;
        }).build()).reward((Reward)new Reward.ExperienceReward(2000, 100)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)1.3f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)30.0f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.35f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.35f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.45f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROT_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.35f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.3f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.15f))).wave(w -> w.maxWaveTime(6400).setupTime(240).entity((WaveEntity)InvaderWaveEntity.createRandom(3)).entity((WaveEntity)StandardWaveEntity.builder((EntityType)EntityType.VEX).count(2).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)30.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR_TOUGHNESS, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)20.0f)).addModifier((WaveModifier)AffixWaveModifier.create()).build()).reward((Reward)new Reward.ExperienceReward(2500, 125)).modifier((WaveModifier)WaveModifier.LootTableModifier.createEmpty()).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.35f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)15.0f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.4f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.4f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.5f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROT_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.5f)).modifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.08f))).wave(w -> w.maxWaveTime(2000).setupTime(300).entity((WaveEntity)ApothGateProvider.elite((EntityType<? extends Mob>)EntityType.GOAT, (DynamicHolder<Elite>)EliteRegistry.INSTANCE.holder(Apotheosis.loc("overworld/craig")), "elite.apotheosis.craig", e -> e.finalizeSpawn(false).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)5.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)50.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ARMOR_TOUGHNESS, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)25.0f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.5f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROJECTILE_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.5f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.ARMOR_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.75f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)ALObjects.Attributes.PROT_SHRED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.5f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE, (float)0.5f)).addModifier((WaveModifier)WaveModifier.AttributeModifier.create((Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, (float)0.2f))))).keyReward((Reward)new Reward.CountedReward((Reward)AffixItemReward.create(Rarities.MYTHIC), 5)).keyReward((Reward)new Reward.CountedReward((Reward)GemReward.create(Purity.PERFECT), 10)).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.GEM_DUST, 64))).keyReward((Reward)new Reward.StackReward(new ItemStack(Apoth.Items.MYTHIC_MATERIAL, 64))).keyReward((Reward)new Reward.StackReward(this.endlessInvaderGatePearl())));
    }

    private void tieredGateway(String path, UnaryOperator<TieredGateway.Builder> config) {
        this.add(Apotheosis.loc(path), (CodecProvider)((TieredGateway.Builder)config.apply(TieredGateway.builder())).build());
    }

    private void endlessGateway(String path, UnaryOperator<EndlessGateway.Builder> config) {
        this.add(Apotheosis.loc(path), (CodecProvider)((EndlessGateway.Builder)config.apply(EndlessGateway.builder())).build());
    }

    private ItemStack endlessInvaderGatePearl() {
        ItemStack stack = new ItemStack(GatewayObjects.GATE_PEARL);
        GatePearlItem.setGate((ItemStack)stack, (DynamicHolder)GatewayRegistry.INSTANCE.holder(Apotheosis.loc("endless_invader")));
        return stack;
    }

    public static EliteWaveEntity elite(EntityType<? extends Mob> entity, DynamicHolder<Elite> elite, String desc, UnaryOperator<StandardWaveEntity.Builder> baseEntity) {
        return new EliteWaveEntity((WaveEntity)((StandardWaveEntity.Builder)baseEntity.apply(new StandardWaveEntity.Builder(entity))).build(), elite, Optional.of(desc));
    }
}

