/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.ItemAffixes;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.util.BasicBossData;
import dev.shadowsoffire.apotheosis.mobs.util.BossStats;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.apothic_attributes.modifiers.EquipmentSlotCompat;
import dev.shadowsoffire.apothic_enchanting.asm.EnchHooks;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.systems.gear.GearSet;
import dev.shadowsoffire.placebo.systems.gear.GearSetRegistry;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.jetbrains.annotations.Nullable;

public record Invader(BasicBossData basicData, EntityType<?> entity, AABB size, Map<LootRarity, BossStats> stats) implements CodecProvider<Invader>,
Constraints.Constrained,
TieredWeights.Weighted
{
    public static final String BOSS_KEY = "apoth.boss";
    public static final String RARITY_KEY = "apoth.boss.rarity";
    public static final String INVADER_ATTR_PREFIX = "apothic_invader_";
    public static final Codec<Invader> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BasicBossData.CODEC.fieldOf("basic_data").forGetter(Invader::basicData), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(Invader::entity), (App)BasicBossData.AABB_CODEC.fieldOf("size").forGetter(Invader::size), (App)LootRarity.mapCodec(BossStats.CODEC).fieldOf("stats").forGetter(Invader::stats)).apply((Applicative)inst, Invader::new));
    public static final Predicate<Goal> IS_VILLAGER_ATTACK = a -> a instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoal)a).targetType == Villager.class;

    @Override
    public TieredWeights weights() {
        return this.basicData.weights();
    }

    @Override
    public Constraints constraints() {
        return this.basicData.constraints();
    }

    public Mob createBoss(ServerLevelAccessor world, BlockPos pos, GenContext ctx) {
        return this.createBoss(world, pos, ctx, null);
    }

    public Mob createBoss(ServerLevelAccessor level, BlockPos pos, GenContext ctx, @Nullable LootRarity rarity) {
        Optional<CompoundTag> nbt = this.basicData.nbt();
        CompoundTag fakeNbt = nbt.map(CompoundTag::copy).orElse(new CompoundTag());
        fakeNbt.putString("id", EntityType.getKey(this.entity).toString());
        Mob entity = (Mob)EntityType.loadEntityRecursive((CompoundTag)fakeNbt, (Level)level.getLevel(), Function.identity());
        this.initBoss(entity, ctx, rarity);
        if (this.basicData.finalizeSpawn()) {
            // empty if block
        }
        if (nbt.isPresent()) {
            entity.readAdditionalSaveData(nbt.get());
        }
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, ctx.rand().nextFloat() * 360.0f, 0.0f);
        if (this.basicData.hasMount()) {
            entity = this.basicData.createMount(level, pos, entity);
        }
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, ctx.rand().nextFloat() * 360.0f, 0.0f);
        return entity;
    }

    public void initBoss(Mob mob, GenContext ctx, @Nullable LootRarity rarity) {
        RandomSource rand = ctx.rand();
        if (rarity == null) {
            rarity = LootRarity.random(ctx, this.stats.keySet());
        }
        BossStats stats = this.stats.get(rarity);
        int duration = mob instanceof Creeper ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance chancedEffectInstance : stats.effects()) {
            if (!(rand.nextFloat() <= chancedEffectInstance.chance())) continue;
            mob.addEffect(chancedEffectInstance.create(rand, duration));
        }
        int i = 0;
        for (RandomAttributeModifier modif : stats.modifiers()) {
            modif.apply(this.createAttributeModifierId(i++), rand, (LivingEntity)mob);
        }
        mob.goalSelector.getAvailableGoals().removeIf(IS_VILLAGER_ATTACK);
        this.basicData.applyEntityName(rand, mob);
        GearSet gearSet = this.basicData.applyGearSet(mob, ctx);
        if (gearSet != null) {
            boolean anyValid = false;
            for (EquipmentSlot t : EquipmentSlot.values()) {
                ItemStack s = mob.getItemBySlot(t);
                if (s.isEmpty() || LootCategory.forItem(s).isNone()) continue;
                anyValid = true;
                break;
            }
            if (!anyValid) {
                Apotheosis.LOGGER.error("Attempted to apply boss gear set " + String.valueOf(GearSetRegistry.INSTANCE.getKey((CodecProvider)gearSet)) + " but it had no valid affix loot items generated.");
            }
        } else {
            ItemStack affixItem = LootController.createRandomLootItem(ctx, rarity);
            LootCategory cat = LootCategory.forItem(affixItem);
            EquipmentSlot slot = Arrays.stream(EquipmentSlot.values()).filter(eSlot -> cat.getSlots().test(EquipmentSlotCompat.fromVanilla((EquipmentSlot)eSlot))).findAny().orElse(EquipmentSlot.MAINHAND);
            mob.setItemSlot(slot, affixItem);
        }
        EquipmentSlot[] slots = EquipmentSlot.values();
        EquipmentSlot guaranteed = slots[rand.nextInt(6)];
        int tries = 50;
        ItemStack temp = mob.getItemBySlot(guaranteed);
        while (temp.isEmpty() || LootCategory.forItem(temp) == Apoth.LootCategories.NONE) {
            guaranteed = slots[rand.nextInt(6)];
            temp = mob.getItemBySlot(guaranteed);
            if (tries-- > 0) continue;
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack stack = mob.getItemBySlot(s);
            if (stack.isEmpty()) continue;
            if (s == guaranteed) {
                mob.setDropChance(s, 2.0f);
                mob.setItemSlot(s, Invader.modifyBossItem(stack, mob.getName(), ctx, rarity, stats.enchLevels().primary(), mob.level().registryAccess()));
                mob.setCustomName((Component)mob.getName().copy().withStyle(Style.EMPTY.withColor(rarity.color())));
                continue;
            }
            if (!(rand.nextFloat() < stats.enchantChance())) continue;
            Invader.enchantBossItem(rand, stack, stats.enchLevels().secondary(), true, mob.level().registryAccess());
            mob.setItemSlot(s, stack);
        }
        mob.getPersistentData().putBoolean(BOSS_KEY, true);
        mob.getPersistentData().putString(RARITY_KEY, RarityRegistry.INSTANCE.getKey(rarity).toString());
        mob.setHealth(mob.getMaxHealth());
        if (AdventureConfig.bossGlowOnSpawn) {
            mob.addEffect(new MobEffectInstance(MobEffects.GLOWING, 3600, 0, true, false));
        }
        this.basicData.appendBonusLoot(mob);
    }

    public Codec<? extends Invader> getCodec() {
        return CODEC;
    }

    protected ResourceLocation createAttributeModifierId(int index) {
        ResourceLocation key = InvaderRegistry.INSTANCE.getKey(this);
        return ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)(INVADER_ATTR_PREFIX + key.getPath() + "_modif_" + index));
    }

    public static void enchantBossItem(RandomSource rand, ItemStack stack, int level, boolean treasure, RegistryAccess reg) {
        Stream available = reg.registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.ON_MOB_SPAWN_EQUIPMENT).map(HolderSet::stream).orElse(Stream.empty());
        List ench = EnchantmentHelper.selectEnchantment((RandomSource)rand, (ItemStack)stack, (int)level, available);
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
        ench.stream().filter(d -> !d.enchantment.is(EnchantmentTags.CURSE)).forEach(i -> builder.upgrade(i.enchantment, i.level));
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)builder.toImmutable());
    }

    public static ItemStack modifyBossItem(ItemStack stack, Component bossName, GenContext ctx, LootRarity rarity, int enchLevel, RegistryAccess reg) {
        List<Holder.Reference> curses;
        RandomSource rand = ctx.rand();
        if (enchLevel > 0) {
            Invader.enchantBossItem(rand, stack, enchLevel, true, reg);
        }
        NameHelper.setItemName(rand, stack);
        stack = LootController.createLootItem(stack, LootCategory.forItem(stack), rarity, ctx);
        ItemAffixes.Builder builder = ((ItemAffixes)stack.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY)).toBuilder();
        for (DynamicHolder afx : builder.keySet()) {
            builder.upgrade((DynamicHolder<Affix>)afx, Math.min(1.0f, builder.getLevel((DynamicHolder<Affix>)afx) + Mth.nextFloat((RandomSource)rand, (float)0.1f, (float)0.25f)));
        }
        AffixHelper.setAffixes(stack, builder.build());
        MutableComponent bossOwnerName = Component.translatable((String)NameHelper.ownershipFormat, (Object[])new Object[]{bossName});
        Component name = AffixHelper.getName(stack);
        ComponentContents componentContents = name.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            String oldKey = tc.getKey();
            String newKey = "misc.apotheosis.affix_name.two".equals(oldKey) ? "misc.apotheosis.affix_name.three" : "misc.apotheosis.affix_name.four";
            Object[] newArgs = new Object[tc.getArgs().length + 1];
            newArgs[0] = bossOwnerName;
            for (int i = 1; i < newArgs.length; ++i) {
                newArgs[i] = tc.getArgs()[i - 1];
            }
            MutableComponent copy = Component.translatable((String)newKey, (Object[])newArgs).withStyle(name.getStyle().withItalic(Boolean.valueOf(false)));
            RegistryFriendlyByteBuf rfbb = new RegistryFriendlyByteBuf(Unpooled.buffer(), reg, ConnectionType.NEOFORGE);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)rfbb, (Object)copy);
            Component deserialized = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)rfbb);
            AffixHelper.setName(stack, deserialized);
        }
        ItemEnchantments.Mutable enchMap = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry e2 : EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet()) {
            if (e2.getKey() == null) continue;
            enchMap.upgrade((Holder)e2.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)((Enchantment)((Holder)e2.getKey()).value())), e2.getIntValue() + rand.nextInt(2)));
        }
        if (AdventureConfig.curseBossItems && !(curses = reg.registryOrThrow(Registries.ENCHANTMENT).holders().filter(e -> e.is(EnchantmentTags.CURSE) && e.is(EnchantmentTags.ON_MOB_SPAWN_EQUIPMENT)).toList()).isEmpty()) {
            Holder curse = (Holder)curses.get(rand.nextInt(curses.size()));
            enchMap.upgrade(curse, Mth.nextInt((RandomSource)rand, (int)1, (int)EnchHooks.getMaxLevel((Enchantment)((Enchantment)curse.value()))));
        }
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchMap.toImmutable());
        stack.set(Apoth.Components.FROM_BOSS, (Object)true);
        return stack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BasicBossData basicData;
        private EntityType<? extends Mob> entity;
        private AABB size;
        private Map<LootRarity, BossStats> stats = new HashMap<LootRarity, BossStats>();

        public Builder basicData(UnaryOperator<BasicBossData.Builder> config) {
            this.basicData = ((BasicBossData.Builder)config.apply(BasicBossData.builder())).build();
            return this;
        }

        public Builder entity(EntityType<? extends Mob> entity) {
            this.entity = entity;
            return this;
        }

        public Builder size(double width, double height) {
            this.size = new AABB(0.0, 0.0, 0.0, width, height, width);
            return this;
        }

        public Builder stats(LootRarity rarity, UnaryOperator<BossStats.Builder> config) {
            this.stats.put(rarity, ((BossStats.Builder)config.apply(BossStats.builder())).build());
            return this;
        }

        public Invader build() {
            if (this.basicData == null) {
                throw new IllegalStateException("BasicBossData must be set");
            }
            if (this.entity == null) {
                throw new IllegalStateException("Entity type must be set");
            }
            if (this.size == null) {
                throw new IllegalStateException("Size must be set");
            }
            if (this.stats.isEmpty()) {
                throw new IllegalStateException("Stats must not be empty");
            }
            return new Invader(this.basicData, this.entity, this.size, this.stats);
        }
    }
}

