/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record AffixData(float chance, Set<LootRarity> rarities) {
    public static final AffixData DEFAULT = new AffixData(-1.0f, Set.of());
    public static final Codec<AffixData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("affix_chance").forGetter(AffixData::chance), (App)PlaceboCodecs.setOf(LootRarity.CODEC).optionalFieldOf("rarities", Set.of()).forGetter(AffixData::rarities)).apply((Applicative)inst, AffixData::new));

    @Nullable
    public EquipmentSlot applyTo(Mob mob, GenContext ctx, int enchLevel, boolean guaranteeDrop) {
        RandomSource rand = ctx.rand();
        if (rand.nextFloat() > this.chance()) {
            return null;
        }
        EquipmentSlot[] slots = AffixData.getRandomSlots(rand);
        ItemStack temp = ItemStack.EMPTY;
        EquipmentSlot selectedSlot = null;
        EquipmentSlot[] equipmentSlotArray = slots;
        int n = equipmentSlotArray.length;
        for (int i = 0; i < n; ++i) {
            EquipmentSlot slot;
            selectedSlot = slot = equipmentSlotArray[i];
            temp = mob.getItemBySlot(slot);
            if (!LootCategory.forItem(temp).isNone()) break;
        }
        if (LootCategory.forItem(temp).isNone()) {
            return null;
        }
        LootRarity rarity = LootRarity.random(ctx, this.rarities());
        if (mob.hasCustomName()) {
            mob.setCustomName((Component)mob.getCustomName().plainCopy().withStyle(Style.EMPTY.withColor(rarity.color())));
        }
        Invader.modifyBossItem(temp, mob.getName(), ctx, rarity, enchLevel, mob.level().registryAccess());
        if (guaranteeDrop) {
            mob.setDropChance(selectedSlot, 2.0f);
        }
        return selectedSlot;
    }

    private static EquipmentSlot[] getRandomSlots(RandomSource rand) {
        EquipmentSlot[] slots = EquipmentSlot.values();
        for (int i = slots.length - 1; i > 0; --i) {
            int index = rand.nextInt(i + 1);
            EquipmentSlot v = slots[index];
            slots[index] = slots[i];
            slots[i] = v;
        }
        return slots;
    }
}

