/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.kubeutils.kubejs.events;

import dev.latvian.mods.kubejs.core.EntityKJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.item.ItemHandlerUtils;
import dev.latvian.mods.kubejs.player.KubeJSPlayerEventHandler;
import dev.latvian.mods.rhino.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import pro.mikey.kubeutils.events.KuEvents;
import pro.mikey.kubeutils.utils.Utils;
import pro.mikey.kubeutils.utils.annotations.KuEvent;

@KuEvent(value=KuEvents.PLAYER_STARTER_ITEMS)
public class PlayerStarterItems
extends KubeJSPlayerEventHandler
implements KubeEvent {
    public static final String STARTER_ITEMS_GIVEN_FLAG = Utils.kuIdStorage("sig");
    private final Player player;
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private final Map<EquipmentSlot, ItemStack> armorItems = new HashMap<EquipmentSlot, ItemStack>();
    public String triggeredFrom = "join";

    public PlayerStarterItems(Player player) {
        this.player = player;
    }

    public PlayerStarterItems(Player player, String triggeredFrom) {
        this.player = player;
        this.triggeredFrom = triggeredFrom;
    }

    public void addItems(ItemStack ... items) {
        this.items.addAll(List.of(items));
    }

    public void addEquipmentItem(String equipmentSlot, ItemStack item) {
        EquipmentSlot slot = Arrays.stream(EquipmentSlot.values()).filter(e -> e.getName().equalsIgnoreCase(equipmentSlot)).findFirst().orElse(EquipmentSlot.CHEST);
        this.armorItems.put(slot, item);
    }

    @Nullable
    public Object defaultExitValue(Context cx) {
        return super.defaultExitValue(cx);
    }

    public void afterPosted(EventResult cancelled) {
        if (cancelled.interruptTrue()) {
            return;
        }
        boolean inserted = false;
        if (this.items.size() > 0) {
            this.items.forEach(item -> ItemHandlerUtils.giveItemToPlayer((Player)this.player, (ItemStack)item, (int)-1));
            inserted = true;
        }
        if (this.armorItems.size() > 0) {
            this.armorItems.forEach((key, value) -> {
                this.player.setItemSlot(key, value);
                if (this.player.getItemBySlot(key).getItem() != value.getItem()) {
                    ItemHandlerUtils.giveItemToPlayer((Player)this.player, (ItemStack)value, (int)-1);
                }
            });
            inserted = true;
        }
        if (inserted) {
            ((EntityKJS)this.player).kjs$getPersistentData().putBoolean(STARTER_ITEMS_GIVEN_FLAG, true);
        }
    }

    public Player getEntity() {
        return this.player;
    }
}

