/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.compat;

import com.breakinblocks.beer.Beer;
import com.breakinblocks.beer.Config;
import com.breakinblocks.beer.recipe.EnchantingModifierRecipeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class EnchantingTableCategory
implements IRecipeCategory<EnchantingModifierRecipeType> {
    public static final RecipeType<EnchantingModifierRecipeType> TYPE = RecipeType.create((String)"beer", (String)"enchanting_modifiers", EnchantingModifierRecipeType.class);
    public static final ResourceLocation TEXTURES = Beer.rl("textures/gui/enchanting_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public EnchantingTableCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(169, 75);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE));
        this.title = Component.translatable((String)"beer.jei.category.enchanting_modifiers");
    }

    @NotNull
    public RecipeType<EnchantingModifierRecipeType> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EnchantingModifierRecipeType recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 11).addIngredients(recipe.getMainhandInput());
        if (recipe.getOffhandInput() != Ingredient.EMPTY) {
            builder.addSlot(RecipeIngredientRole.INPUT, 11, 48).addIngredients(recipe.getOffhandInput());
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE));
    }

    public void draw(@NotNull EnchantingModifierRecipeType recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gfx, double mouseX, double mouseY) {
        Screen scn = Minecraft.getInstance().screen;
        if (scn == null) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        gfx.blit(TEXTURES, 0, 0, 0.0f, 0.0f, this.getWidth(), this.getHeight(), 256, 256);
        if (recipe.getOffhandInput() == Ingredient.EMPTY) {
            gfx.blit(TEXTURES, 1, 31, 0, 0.0f, 88.0f, 28, 34, 256, 256);
        }
        gfx.renderFakeItem(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE), 31, 29);
        String effectText = recipe.getEffectKey();
        int textColor = 0;
        int textWidth = font.width(effectText);
        int left = 168;
        int top = 34;
        gfx.drawString(font, effectText, left - textWidth, top, textColor, false);
        if (Config.enableXpCosts) {
            this.drawXPCost(gfx, recipe, font);
        }
        this.drawTooltipsIfHovered(scn, gfx, recipe, font, mouseX, mouseY);
    }

    private void drawXPCost(GuiGraphics gfx, EnchantingModifierRecipeType recipe, Font font) {
        boolean isDecrease = recipe.getOffhandInput() != Ingredient.EMPTY;
        gfx.renderFakeItem(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), 75, 50);
        if (isDecrease) {
            MutableComponent xpText = Component.translatable((String)"beer.jei.modifier.xp_gain", (Object[])new Object[]{Config.xpCostPerModifier});
            gfx.drawString(font, (Component)xpText, 95, 54, 0x55FF55, true);
        } else {
            MutableComponent xpText = Component.translatable((String)"beer.jei.modifier.xp_cost", (Object[])new Object[]{Config.xpCostPerModifier});
            gfx.drawString(font, (Component)xpText, 95, 54, 0xFF5555, true);
        }
    }

    private void drawTooltipsIfHovered(Screen scn, GuiGraphics gfx, EnchantingModifierRecipeType recipe, Font font, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        int left = -1;
        int top = 13;
        int width = 9;
        int height = 12;
        if (this.isHover(mouseX, mouseY, left, top, width, height)) {
            gfx.blit(TEXTURES, -1, 13, 0, 0.0f, 75.0f, 10, 12, 256, 256);
            tooltips.add((Component)Component.translatable((String)"beer.jei.category.main_hand"));
        }
        left = 0;
        top = 50;
        if (recipe.getOffhandInput() != Ingredient.EMPTY && this.isHover(mouseX, mouseY, left, top, width, height)) {
            gfx.blit(TEXTURES, -1, 50, 0, 0.0f, 75.0f, 10, 12, 256, 256);
            tooltips.add((Component)Component.translatable((String)"beer.jei.category.off_hand"));
            tooltips.add((Component)Component.translatable((String)"beer.jei.category.not_consumed").withStyle(ChatFormatting.GRAY));
        }
        if (this.isHover(mouseX, mouseY, left = 36, top = 30, width = 16, height = 16)) {
            tooltips.add((Component)Component.translatable((String)"beer.jei.category.right_click_table"));
        } else {
            String effectText = recipe.getEffectKey();
            left = 168;
            top = 34;
            width = font.width(effectText);
            Objects.requireNonNull(font);
            height = 9 + 1;
            if (this.isHover(mouseX, mouseY, left - width, top, width, height)) {
                tooltips.add((Component)Component.translatable((String)recipe.getDescriptionKey()));
            }
        }
        if (!tooltips.isEmpty()) {
            int maxWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            maxWidth = maxWidth - (maxWidth - 210) / 2 - 210;
            EnchantingTableCategory.renderComponentTooltip(scn, gfx, tooltips, (int)mouseX, (int)mouseY, maxWidth, font);
        }
    }

    private boolean isHover(double mouseX, double mouseY, int left, int top, int width, int height) {
        return mouseX >= (double)left && mouseX < (double)(left + width) && mouseY >= (double)top && mouseY < (double)(top + height);
    }

    private static void renderComponentTooltip(Screen scn, GuiGraphics gfx, List<Component> list, int x, int y, int maxWidth, Font font) {
        List text = list.stream().map(c -> font.getSplitter().splitLines((FormattedText)c, maxWidth, c.getStyle())).flatMap(Collection::stream).toList();
        gfx.renderComponentTooltip(font, text, x, y, ItemStack.EMPTY);
    }
}

