/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.event;

import com.breakinblocks.beer.Config;
import com.breakinblocks.beer.compat.EnchantingModifierRecipe;
import com.breakinblocks.beer.data.BeerDataAttachments;
import com.breakinblocks.beer.data.EnchantingTableRangeData;
import com.breakinblocks.beer.network.ApplyItemModifierPacket;
import com.breakinblocks.beer.network.NetworkHandler;
import com.breakinblocks.beer.network.SyncEnchantingDataPacket;
import com.breakinblocks.beer.recipe.BeerRecipes;
import com.breakinblocks.beer.recipe.EnchantingModifierRecipeType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="beer")
public class ItemModifierHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack offhandItem;
        if (!Config.enableItemModifiers) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        if (hand != InteractionHand.MAIN_HAND) {
            return;
        }
        if (!player.isShiftKeyDown()) {
            return;
        }
        if (!level.getBlockState(pos).is(Blocks.ENCHANTING_TABLE)) {
            return;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        ModifierType modifierType = ItemModifierHandler.getModifierType(level, heldItem, offhandItem = player.getOffhandItem());
        if (modifierType == null) {
            return;
        }
        boolean decreaseMode = ItemModifierHandler.isDecreaseMode(level, heldItem, offhandItem);
        if (!level.isClientSide()) {
            ItemModifierHandler.applyModification(level, pos, player, modifierType, decreaseMode, heldItem);
        }
        event.setCanceled(true);
    }

    private static ModifierType getModifierType(Level level, ItemStack mainhandStack, ItemStack offhandStack) {
        if (level.isClientSide()) {
            return null;
        }
        try {
            RecipeManager recipeManager = level.getRecipeManager();
            RecipeType<EnchantingModifierRecipeType> recipeType = BeerRecipes.ENCHANTING_MODIFIER_TYPE.get();
            if (recipeManager == null || recipeType == null) {
                return null;
            }
            List allRecipes = recipeManager.getAllRecipesFor(recipeType);
            for (RecipeHolder recipeHolder : allRecipes) {
                EnchantingModifierRecipeType recipe = (EnchantingModifierRecipeType)recipeHolder.value();
                if (!recipe.getMainhandInput().test(mainhandStack) || recipe.getOffhandInput() != null && !recipe.getOffhandInput().isEmpty() && (offhandStack.isEmpty() || !recipe.getOffhandInput().test(offhandStack))) continue;
                return ItemModifierHandler.convertToModifierType(recipe.getModifierType());
            }
        }
        catch (Exception e) {
            System.err.println("[BEER] Error loading modifier type from recipes: " + e.getMessage());
        }
        return null;
    }

    private static boolean isDecreaseMode(Level level, ItemStack mainhandStack, ItemStack offhandStack) {
        if (level.isClientSide()) {
            return false;
        }
        try {
            RecipeManager recipeManager = level.getRecipeManager();
            RecipeType<EnchantingModifierRecipeType> recipeType = BeerRecipes.ENCHANTING_MODIFIER_TYPE.get();
            if (recipeManager == null || recipeType == null) {
                return false;
            }
            List allRecipes = recipeManager.getAllRecipesFor(recipeType);
            for (RecipeHolder recipeHolder : allRecipes) {
                EnchantingModifierRecipeType recipe = (EnchantingModifierRecipeType)recipeHolder.value();
                if (!recipe.getMainhandInput().test(mainhandStack) || recipe.getOffhandInput() == null || recipe.getOffhandInput().isEmpty() || offhandStack.isEmpty() || !recipe.getOffhandInput().test(offhandStack)) continue;
                return recipe.getEffectKey().startsWith("-");
            }
        }
        catch (Exception e) {
            System.err.println("[BEER] Error checking decrease mode from recipes: " + e.getMessage());
        }
        return false;
    }

    private static ModifierType convertToModifierType(EnchantingModifierRecipe.ModifierType recipeType) {
        switch (recipeType) {
            case X_WIDTH: {
                return ModifierType.X_WIDTH;
            }
            case Y_HEIGHT: {
                return ModifierType.Y_HEIGHT;
            }
            case Z_WIDTH: {
                return ModifierType.Z_WIDTH;
            }
        }
        return null;
    }

    private static void applyModification(Level level, BlockPos pos, Player player, ModifierType modifierType, boolean decreaseMode, ItemStack heldItem) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof EnchantingTableBlockEntity)) {
            return;
        }
        EnchantingTableRangeData data = (EnchantingTableRangeData)blockEntity.getData(BeerDataAttachments.ENCHANTING_TABLE_RANGE.get());
        int modifierAmount = Config.modifierAmountPerUse;
        if (decreaseMode) {
            modifierAmount = -modifierAmount;
        }
        boolean success = false;
        switch (modifierType.ordinal()) {
            case 0: {
                int newX = data.getItemModifiersX() + modifierAmount;
                if (!ItemModifierHandler.isValidModifierX(newX)) break;
                data.addItemModifierX(modifierAmount);
                success = true;
                break;
            }
            case 1: {
                int newZ = data.getItemModifiersZ() + modifierAmount;
                if (!ItemModifierHandler.isValidModifierZ(newZ)) break;
                data.addItemModifierZ(modifierAmount);
                success = true;
                break;
            }
            case 2: {
                int newY = data.getItemModifiersY() + modifierAmount;
                if (!ItemModifierHandler.isValidModifierY(newY)) break;
                data.addItemModifierY(modifierAmount);
                success = true;
            }
        }
        if (success) {
            if (Config.enableXpCosts) {
                int xpCost = Config.xpCostPerModifier;
                if (decreaseMode) {
                    player.giveExperiencePoints(xpCost);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        MutableComponent xpGainMessage = Component.translatable((String)"beer.message.xp_gained", (Object[])new Object[]{xpCost}).withStyle(ChatFormatting.GREEN);
                        serverPlayer.sendSystemMessage((Component)xpGainMessage, true);
                    }
                } else {
                    int totalXp = ItemModifierHandler.getTotalExperience(player);
                    if (totalXp < xpCost && !player.getAbilities().instabuild) {
                        level.playSound(null, pos, SoundEvents.VILLAGER_NO, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            MutableComponent xpMessage = Component.translatable((String)"beer.message.insufficient_xp", (Object[])new Object[]{xpCost, totalXp}).withStyle(ChatFormatting.RED);
                            serverPlayer.sendSystemMessage((Component)xpMessage, true);
                            NetworkHandler.sendToPlayer(new ApplyItemModifierPacket(pos, modifierType, true, false, 0, 0, 0), serverPlayer);
                        }
                        return;
                    }
                    if (!player.getAbilities().instabuild) {
                        ItemModifierHandler.addExperience(player, -xpCost);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        MutableComponent xpConsumedMessage = Component.translatable((String)"beer.message.xp_consumed", (Object[])new Object[]{xpCost}).withStyle(ChatFormatting.YELLOW);
                        serverPlayer.sendSystemMessage((Component)xpConsumedMessage, true);
                    }
                }
            }
            blockEntity.setChanged();
            if (Config.consumeItems && !player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.2f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.sendToPlayer(new ApplyItemModifierPacket(pos, modifierType, !decreaseMode, true, data.getEffectiveRangeX(), data.getEffectiveRangeY(), data.getEffectiveRangeZ()), serverPlayer);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SyncEnchantingDataPacket syncPacket = SyncEnchantingDataPacket.create(pos, data);
                NetworkHandler.sendToPlayersNear(syncPacket, serverLevel, pos, 64.0);
            }
        } else {
            level.playSound(null, pos, SoundEvents.VILLAGER_NO, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.sendToPlayer(new ApplyItemModifierPacket(pos, modifierType, !decreaseMode, false, 0, 0, 0), serverPlayer);
            }
        }
    }

    private static boolean isValidModifier(int modifier) {
        return Math.abs(modifier) <= Config.maxItemModifiersPerAxis;
    }

    private static boolean isValidModifierX(int modifier) {
        return modifier >= -2 && modifier <= Config.maxItemModifiersPerAxis;
    }

    private static boolean isValidModifierY(int modifier) {
        return modifier >= -1 && modifier <= Config.maxItemModifiersPerAxis;
    }

    private static boolean isValidModifierZ(int modifier) {
        return modifier >= -2 && modifier <= Config.maxItemModifiersPerAxis;
    }

    private static boolean isValidEffectiveRange(int effectiveRange, int maxAllowed) {
        return effectiveRange >= 1 && effectiveRange <= maxAllowed;
    }

    private static boolean isValidEffectiveRangeY(int effectiveRange, int maxAllowed) {
        return effectiveRange >= 0 && effectiveRange <= maxAllowed;
    }

    private static int getTotalExperience(Player player) {
        return (int)((float)ItemModifierHandler.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    private static int getExperienceForLevel(int level) {
        if (level >= 30) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level >= 16) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return level * level + 6 * level;
    }

    private static void addExperience(Player player, int xp) {
        int level;
        int totalXp;
        player.totalExperience = totalXp = ItemModifierHandler.getTotalExperience(player) + xp;
        if (totalXp <= 0) {
            player.experienceLevel = 0;
            player.experienceProgress = 0.0f;
            return;
        }
        player.experienceLevel = level = ItemModifierHandler.getLevelForExperience(totalXp);
        int xpForCurrentLevel = ItemModifierHandler.getExperienceForLevel(level);
        int xpForNextLevel = ItemModifierHandler.getExperienceForLevel(level + 1);
        int currentLevelXp = totalXp - xpForCurrentLevel;
        int neededForNext = xpForNextLevel - xpForCurrentLevel;
        player.experienceProgress = (float)currentLevelXp / (float)neededForNext;
    }

    private static int getLevelForExperience(int xp) {
        if (xp >= 1395) {
            return (int)(8.1 + Math.sqrt(0.4 * (double)(xp - 1395)));
        }
        if (xp >= 315) {
            return (int)(8.1 + Math.sqrt(0.4 * (double)(xp - 315)));
        }
        return (int)(-3.0 + Math.sqrt(9 + 4 * xp)) / 2;
    }

    public static enum ModifierType {
        X_WIDTH,
        Z_WIDTH,
        Y_HEIGHT;

    }
}

