/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridRotateHandler;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class DefaultRectangleGridRotateHandler
implements GridRotateHandler<AbstractContainerMenu> {
    private int rotateRectangularGrid(int slot, int width, int height, boolean clockwise) {
        boolean d4;
        boolean stay = false;
        boolean moveRight = true;
        int moveLeft = -1;
        int moveUp = -width;
        int moveDown = width;
        int x = slot % width;
        int y = slot / width;
        int smallestSide = Math.min(width, height);
        int hss = smallestSide / 2;
        int td = y;
        int bd = height - 1 - y;
        int ld = x;
        int rd = width - 1 - x;
        int ved = Math.min(td, bd);
        int hed = Math.min(rd, ld);
        int civcd = Math.max(hss - ved, 0);
        int cihcd = Math.max(hss - hed, 0);
        boolean diagonal = Math.abs(civcd) - Math.abs(cihcd) == 0 && civcd != 0 && cihcd != 0;
        boolean verticalQuadrant = civcd - cihcd > 0;
        boolean horizontalQuadrant = cihcd - civcd > 0;
        boolean leftHalf = ld < rd;
        boolean topHalf = td < bd;
        boolean q1 = verticalQuadrant && topHalf;
        boolean q2 = horizontalQuadrant && !leftHalf;
        boolean q3 = verticalQuadrant && !topHalf;
        boolean q4 = horizontalQuadrant && leftHalf;
        boolean d1 = diagonal && topHalf && leftHalf;
        boolean d2 = diagonal && topHalf && !leftHalf;
        boolean d3 = diagonal && !topHalf && !leftHalf;
        boolean bl = d4 = diagonal && !topHalf && leftHalf;
        if (clockwise) {
            if (q1 || d1) {
                return 1;
            }
            if (q3 || d3) {
                return -1;
            }
            if (q2 || d2) {
                return moveDown;
            }
            if (q4 || d4) {
                return moveUp;
            }
            return 0;
        }
        if (q1 || d2) {
            return -1;
        }
        if (q3 || d4) {
            return 1;
        }
        if (q2 || d3) {
            return moveUp;
        }
        if (q4 || d1) {
            return moveDown;
        }
        return 0;
    }

    @Override
    public void rotateGrid(CraftingGrid grid, Player player, AbstractContainerMenu menu, boolean reverse) {
        int slotIndex;
        int i;
        Container craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        int gridWidth = (int)Math.sqrt(size);
        int gridHeight = (int)Math.sqrt(size);
        SimpleContainer matrixClone = new SimpleContainer(size);
        for (i = 0; i < size; ++i) {
            slotIndex = ((Slot)menu.slots.get(start + i)).getContainerSlot();
            matrixClone.setItem(i, craftMatrix.getItem(slotIndex));
        }
        for (i = 0; i < size; ++i) {
            slotIndex = ((Slot)menu.slots.get(start + i + this.rotateRectangularGrid(i, gridWidth, gridHeight, !reverse))).getContainerSlot();
            craftMatrix.setItem(slotIndex, matrixClone.getItem(i));
        }
        menu.broadcastChanges();
    }
}

