/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items.tools;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.items.AEBaseItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.common.me.itemhost.HostPatternModifier;
import com.glodblock.github.extendedae.container.ContainerPatternModifier;
import com.glodblock.github.extendedae.util.FCUtil;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPatternModifier
extends AEBaseItem
implements IMenuItem {
    public ItemPatternModifier() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player p, @NotNull InteractionHand hand) {
        if (!level.isClientSide()) {
            MenuOpener.open(ContainerPatternModifier.TYPE, (Player)p, (MenuHostLocator)MenuLocators.forHand((Player)p, (InteractionHand)hand));
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)p.getItemInHand(hand));
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        Level world = context.getLevel();
        PatternProviderLogicHost pp = FCUtil.findDevice(PatternProviderLogicHost.class, world, context.getClickedPos(), context.getClickLocation());
        Player player = context.getPlayer();
        boolean didSomething = false;
        if (!world.isClientSide() && player != null && !InteractionUtil.isInAlternateUseMode((Player)player) && pp != null) {
            AppEngInternalInventory inv = this.getMenuHost(player, MenuLocators.forStack((ItemStack)stack), null).getInventoryByName("patternInv");
            for (int slot = 0; slot < inv.size(); ++slot) {
                ItemStack overflow;
                ItemStack pattern = inv.getStackInSlot(slot);
                if (pattern.isEmpty() || !(overflow = pp.getLogic().getPatternInv().addItems(pattern)).isEmpty()) continue;
                inv.setItemDirect(slot, ItemStack.EMPTY);
                didSomething = true;
            }
            return didSomething ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public HostPatternModifier getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return new HostPatternModifier(this, player, locator);
    }
}

