/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.taglist;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.config.EAEConfig;

public class TagStackTransferContext
implements StackTransferContext {
    private final IStorageService internalStorage;
    private final IEnergySource energySource;
    private final IActionSource actionSource;
    private final IPartitionList filter;
    private final int initialOperations;
    private long operationsRemaining;
    private boolean isInverted;

    public TagStackTransferContext(IStorageService internalStorage, IEnergySource energySource, IActionSource actionSource, int operationsRemaining, IPartitionList filter) {
        this.internalStorage = internalStorage;
        this.energySource = energySource;
        this.actionSource = actionSource;
        this.filter = filter;
        this.initialOperations = operationsRemaining;
        this.operationsRemaining = operationsRemaining;
        if (EAEConfig.debugMode) {
            ExtendedAE.LOGGER.debug("Created TagStackTransferContext with filter: {}", (Object)filter.getClass().getSimpleName());
            ExtendedAE.LOGGER.debug("Filter isEmpty: {}", (Object)filter.isEmpty());
        }
    }

    public IStorageService getInternalStorage() {
        return this.internalStorage;
    }

    public IEnergySource getEnergySource() {
        return this.energySource;
    }

    public IActionSource getActionSource() {
        return this.actionSource;
    }

    public int getOperationsRemaining() {
        return (int)this.operationsRemaining;
    }

    public void setOperationsRemaining(int operationsRemaining) {
        this.operationsRemaining = operationsRemaining;
    }

    public boolean hasOperationsLeft() {
        return this.operationsRemaining > 0L;
    }

    public boolean hasDoneWork() {
        return (long)this.initialOperations > this.operationsRemaining;
    }

    public boolean isKeyTypeEnabled(AEKeyType space) {
        return space == AEKeyType.items() || space == AEKeyType.fluids();
    }

    public boolean isInFilter(AEKey key) {
        boolean isListed;
        boolean isEmpty = this.filter.isEmpty();
        boolean bl = isListed = isEmpty || this.filter.isListed(key);
        if (EAEConfig.debugMode) {
            ExtendedAE.LOGGER.debug("isInFilter check for item {}: isEmpty={}, isListed={}, final result={}", new Object[]{key, isEmpty, isListed, isListed});
        }
        return isListed;
    }

    public IPartitionList getFilter() {
        return this.filter;
    }

    public void setInverted(boolean inverted) {
        if (EAEConfig.debugMode && this.isInverted != inverted) {
            ExtendedAE.LOGGER.debug("Filter inversion changed to: {}", (Object)inverted);
        }
        this.isInverted = inverted;
    }

    public boolean isInverted() {
        boolean result;
        boolean bl = result = !this.filter.isEmpty() && this.isInverted;
        if (EAEConfig.debugMode) {
            ExtendedAE.LOGGER.debug("isInverted check: !filter.isEmpty()={}, isInverted={}, result={}", new Object[]{!this.filter.isEmpty(), this.isInverted, result});
        }
        return result;
    }

    public boolean canInsert(AEItemKey what, long amount) {
        boolean canInsert;
        boolean bl = canInsert = this.internalStorage.getInventory().insert((AEKey)what, amount, Actionable.SIMULATE, this.actionSource) > 0L;
        if (EAEConfig.debugMode) {
            ExtendedAE.LOGGER.debug("canInsert check for item {}: {}", (Object)what, (Object)canInsert);
        }
        return canInsert;
    }

    public void reduceOperationsRemaining(long inserted) {
        if (EAEConfig.debugMode) {
            ExtendedAE.LOGGER.debug("Reducing operations remaining by {}: {} -> {}", new Object[]{inserted, this.operationsRemaining, this.operationsRemaining - inserted});
        }
        this.operationsRemaining -= inserted;
    }
}

