/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.AECapabilities;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import com.glodblock.github.extendedae.api.IPage;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PartExInterface
extends AEBasePart
implements InterfaceLogicHost,
IPage {
    public static List<ResourceLocation> MODELS = Arrays.asList(ResourceLocation.fromNamespaceAndPath((String)"extendedae", (String)"part/ex_interface"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_on"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_off"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(3)});
    private static final IGridNodeListener<PartExInterface> NODE_LISTENER = new AEBasePart.NodeListener<PartExInterface>(){

        public void onGridChanged(PartExInterface nodeOwner, IGridNode node) {
            super.onGridChanged((Object)nodeOwner, node);
            nodeOwner.getInterfaceLogic().gridChanged();
        }
    };
    private final InterfaceLogic logic;
    private int page = 0;

    public PartExInterface(IPartItem<?> partItem) {
        super(partItem);
        this.logic = new InterfaceLogic(this.getMainNode(), (InterfaceLogicHost)this, partItem.asItem(), 36);
    }

    public void openMenu(Player player, MenuHostLocator locator) {
        MenuOpener.open(ContainerExInterface.TYPE, (Player)player, (MenuHostLocator)locator);
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(ContainerExInterface.TYPE, (Player)player, (MenuHostLocator)subMenu.getLocator());
    }

    public void saveChanges() {
        this.getHost().markForSave();
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)this, NODE_LISTENER);
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        if (this.getMainNode().hasGridBooted()) {
            this.logic.notifyNeighbors();
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.logic.readFromNBT(data, registries);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        this.logic.writeToNBT(data, registries);
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        this.logic.addDrops(drops);
    }

    public void clearContent() {
        super.clearContent();
        this.logic.clearContent();
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public IConfigManager getConfigManager() {
        return this.logic.getConfigManager();
    }

    public boolean onUseWithoutItem(Player p, Vec3 pos) {
        if (!p.getCommandSenderWorld().isClientSide()) {
            this.openMenu(p, MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public InterfaceLogic getInterfaceLogic() {
        return this.logic;
    }

    public int getPriority() {
        return this.logic.getPriority();
    }

    public void setPriority(int newValue) {
        this.logic.setPriority(newValue);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)UPGRADES)) {
            return this.logic.getUpgrades();
        }
        return super.getSubInventory(id);
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getPartItem());
    }

    public static void registerCapability(RegisterPartCapabilitiesEvent event) {
        event.register(AECapabilities.GENERIC_INTERNAL_INV, (part, context) -> part.logic.getStorage(), PartExInterface.class);
        event.register(AECapabilities.ME_STORAGE, (part, context) -> part.logic.getInventory(), PartExInterface.class);
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }
}

