/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities.matrix;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.orientation.BlockOrientation;
import appeng.api.util.IConfigManager;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.me.cluster.IAEMultiBlock;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.iterators.ChainedIterator;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.blocks.matrix.BlockAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.me.matrix.CalculatorAssemblerMatrix;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class TileAssemblerMatrixBase
extends AENetworkedBlockEntity
implements IAEMultiBlock<ClusterAssemblerMatrix>,
IPowerChannelState {
    protected final CalculatorAssemblerMatrix calc = new CalculatorAssemblerMatrix(this);
    protected final ConfigManager manager;
    protected boolean isCore = false;
    protected CompoundTag previousState = null;
    protected ClusterAssemblerMatrix cluster;

    public TileAssemblerMatrixBase(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL}).addService(IGridMultiblock.class, (IGridNodeService)((IGridMultiblock)this::getMultiblockNodes));
        this.getMainNode().setIdlePowerUsage(0.0);
        this.manager = new ConfigManager(() -> ((TileAssemblerMatrixBase)this).saveChanges());
        this.manager.registerSetting(Settings.PATTERN_ACCESS_TERMINAL, (Enum)YesNo.YES);
    }

    public IConfigManager getConfigManager() {
        return this.manager;
    }

    public CompoundTag getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(CompoundTag previousState) {
        this.previousState = previousState;
    }

    public boolean isCore() {
        return this.isCore;
    }

    public void setCore(boolean core) {
        this.isCore = core;
    }

    protected Item getItemFromBlockEntity() {
        if (this.level == null) {
            return Items.AIR;
        }
        return this.getMatrixBlock().getPresentItem();
    }

    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public void onReady() {
        super.onReady();
        this.getMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity());
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.calculateMultiblock(serverLevel, this.worldPosition);
        }
    }

    public void updateMultiBlock(BlockPos changedPos) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.worldPosition, changedPos);
        }
    }

    public void breakCluster() {
        if (this.cluster != null) {
            ArrayList<BlockPos> places = new ArrayList<BlockPos>();
            for (TileAssemblerMatrixBase blockEntity : this.cluster::getBlockEntities) {
                if (this == blockEntity) {
                    places.add(this.worldPosition);
                    continue;
                }
                for (Direction d : Direction.values()) {
                    BlockPos p = blockEntity.worldPosition.relative(d);
                    if (!this.level.isEmptyBlock(p)) continue;
                    places.add(p);
                }
            }
            if (places.isEmpty()) {
                throw new IllegalStateException(String.valueOf(this.cluster) + " does not contain any kind of blocks, which were destroyed.");
            }
            this.cluster.destroy();
        }
    }

    public boolean isFormed() {
        if (this.isClientSide()) {
            return (Boolean)this.getBlockState().getValue((Property)BlockAssemblerMatrixBase.FORMED);
        }
        return this.cluster != null;
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        data.putBoolean("core", this.isCore);
        this.manager.writeToNBT(data, registries);
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.setCore(data.getBoolean("core"));
        this.manager.readFromNBT(data, registries);
        if (this.isCore) {
            this.setPreviousState(data.copy());
        }
    }

    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateSubType(true);
            }
        }
    }

    public ClusterAssemblerMatrix getCluster() {
        return this.cluster;
    }

    public boolean isValid() {
        return true;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.updateSubType(false);
        }
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.requestModelDataUpdate();
    }

    public boolean isActive() {
        if (!this.isClientSide()) {
            return this.getMainNode().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    @Nullable
    public IItemHandler getPatternInv(Direction side) {
        if (this.cluster == null) {
            return null;
        }
        ArrayList<AppEngInternalInventory> inv = new ArrayList<AppEngInternalInventory>();
        for (TileAssemblerMatrixPattern pc : this.cluster.getPatterns()) {
            inv.add(pc.getExposedInventory());
        }
        return new CombinedInternalInventory(inv.toArray(new InternalInventory[0])).toItemHandler();
    }

    public void updateStatus(ClusterAssemblerMatrix c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateSubType(true);
    }

    public void updateSubType(boolean updateFormed) {
        BlockState newState;
        if (this.level == null || this.notLoaded() || this.isRemoved()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = this.getMainNode().isOnline();
        BlockState current = this.level.getBlockState(this.worldPosition);
        if (current.getBlock() instanceof BlockAssemblerMatrixBase && current != (newState = (BlockState)((BlockState)current.setValue((Property)BlockAssemblerMatrixBase.POWERED, (Comparable)Boolean.valueOf(power))).setValue((Property)BlockAssemblerMatrixBase.FORMED, (Comparable)Boolean.valueOf(formed)))) {
            this.level.setBlock(this.worldPosition, newState, 2);
        }
        if (updateFormed) {
            this.onGridConnectableSidesChanged();
        }
    }

    public boolean isPowered() {
        if (this.isClientSide()) {
            return (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockAssemblerMatrixBase.POWERED);
        }
        return this.getMainNode().isActive();
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        if (this.isFormed()) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.noneOf(Direction.class);
    }

    public BlockAssemblerMatrixBase<?> getMatrixBlock() {
        if (this.level == null || this.notLoaded() || this.isRemoved()) {
            return EAESingletons.ASSEMBLER_MATRIX_FRAME;
        }
        return (BlockAssemblerMatrixBase)this.level.getBlockState(this.worldPosition).getBlock();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator((Object[])new IGridNode[0]);
        }
        ArrayList<IGridNode> nodes = new ArrayList<IGridNode>();
        Iterator<TileAssemblerMatrixBase> it = this.getCluster().getBlockEntities();
        while (it.hasNext()) {
            IGridNode node = it.next().getGridNode();
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes.iterator();
    }
}

