/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.core;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.theme.ThemeHelper;

public abstract class DistanceProvider
implements IToggleableProvider {
    public static final DecimalFormat fmt = new DecimalFormat("#.#");
    private static final int[] colors = new int[]{15702682, 10868391, 9489145, 11545143, 1673044, 678090};

    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static String distance(Accessor<?> accessor) {
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        return fmt.format(accessor.getPlayer().getEyePosition(partialTick).distanceTo(accessor.getHitResult().getLocation()));
    }

    public static void xyz(ITooltip tooltip, Vec3i pos) {
        MutableComponent display = Component.translatable((String)"jade.blockpos", (Object[])new Object[]{DistanceProvider.display(pos.getX(), 0), DistanceProvider.display(pos.getY(), 1), DistanceProvider.display(pos.getZ(), 2)});
        String narrate = I18n.get((String)"narration.jade.blockpos", (Object[])new Object[]{DistanceProvider.narrate(pos.getX()), DistanceProvider.narrate(pos.getY()), DistanceProvider.narrate(pos.getZ())});
        tooltip.add(IElementHelper.get().text((Component)display).message(narrate));
    }

    public static Component display(int i, int colorIndex) {
        if (IThemeHelper.get().isLightColorScheme()) {
            colorIndex += 3;
        }
        return Component.literal((String)Integer.toString(i)).withStyle(ThemeHelper.colorStyle(colors[colorIndex]));
    }

    public static String narrate(int i) {
        return i >= 0 ? Integer.toString(i) : I18n.get((String)"narration.jade.negative", (Object[])new Object[]{-i});
    }

    public void append(ITooltip tooltip, Accessor<?> accessor, BlockPos pos, IPluginConfig config) {
        String distanceMsg;
        boolean distance = config.get(JadeIds.CORE_DISTANCE);
        String distanceVal = distance ? DistanceProvider.distance(accessor) : null;
        String string = distanceMsg = distance ? I18n.get((String)"narration.jade.distance", (Object[])new Object[]{distanceVal}) : null;
        if (config.get(JadeIds.CORE_COORDINATES)) {
            if (config.get(JadeIds.CORE_REL_COORDINATES) && Screen.hasControlDown()) {
                DistanceProvider.xyz(tooltip, (Vec3i)pos.subtract((Vec3i)BlockPos.containing((Position)accessor.getPlayer().getEyePosition())));
            } else {
                DistanceProvider.xyz(tooltip, (Vec3i)pos);
            }
            if (distance) {
                tooltip.append(IElementHelper.get().text((Component)Component.translatable((String)"jade.distance1", (Object[])new Object[]{distanceVal})).message(distanceMsg));
            }
        } else if (distance) {
            tooltip.add(IElementHelper.get().text((Component)Component.translatable((String)"jade.distance2", (Object[])new Object[]{distanceVal})).message(distanceMsg));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.CORE_DISTANCE;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public int getDefaultPriority() {
        return -4600;
    }

    public static class ForBlock
    extends DistanceProvider
    implements IBlockComponentProvider {
        private static final ForBlock INSTANCE = new ForBlock();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            this.append(tooltip, accessor, accessor.getPosition(), config);
        }
    }

    public static class ForEntity
    extends DistanceProvider
    implements IEntityComponentProvider {
        private static final ForEntity INSTANCE = new ForEntity();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            this.append(tooltip, accessor, accessor.getEntity().blockPosition(), config);
        }
    }
}

