/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity;

import de.maxhenkel.easypiglins.MultiItemStackHandler;
import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.ModBlocks;
import de.maxhenkel.easypiglins.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easypiglins.blocks.tileentity.PiglinTileentity;
import de.maxhenkel.easypiglins.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easypiglins.corelib.inventory.ItemListInventory;
import de.maxhenkel.easypiglins.datacomponents.PiglinData;
import de.maxhenkel.easypiglins.gui.BarterSlot;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BartererTileentity
extends PiglinTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> inputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected NonNullList<ItemStack> outputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected MultiItemStackHandler itemHandler = new MultiItemStackHandler(this.inputInventory, this.outputInventory, BarterSlot::isValid);
    protected ItemStackHandler outputHandler = new ItemStackHandler(this.outputInventory);

    public BartererTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.BARTERER.get(), ((BartererBlock)ModBlocks.BARTERER.get()).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        Piglin p = this.getPiglinEntity();
        if (p == null) {
            return;
        }
        if (this.level.getGameTime() % 20L == 0L && this.level.random.nextInt(40) == 0) {
            BartererBlock.playPiglinSound(this.level, this.worldPosition, SoundEvents.PIGLIN_AMBIENT);
        }
        if (this.level.getGameTime() % 120L == 0L) {
            if (this.removeBarteringItem()) {
                this.addLoot(p);
            }
            this.sync();
        }
    }

    public boolean removeBarteringItem() {
        for (ItemStack stack : this.inputInventory) {
            if (!stack.isPiglinCurrency() || stack.getCount() < 1) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public ItemStack getBarteringItem() {
        for (ItemStack stack : this.inputInventory) {
            if (!stack.isPiglinCurrency() || stack.getCount() < 1) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private void addLoot(Piglin piglin) {
        LootTable loottable = this.level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.PIGLIN_BARTERING);
        ObjectArrayList loot = loottable.getRandomItems(new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)piglin).create(LootContextParamSets.PIGLIN_BARTER));
        if (this.level.getRandom().nextInt(5) == 0) {
            BartererBlock.playPiglinSound(this.level, this.getBlockPos(), SoundEvents.PIGLIN_ADMIRING_ITEM);
        }
        for (ItemStack drop : loot) {
            for (int i = 0; i < this.outputHandler.getSlots() && !(drop = this.outputHandler.insertItem(i, drop, false)).isEmpty(); ++i) {
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("InputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true, (HolderLookup.Provider)provider));
        compound.put("OutputInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true, (HolderLookup.Provider)provider));
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.inputInventory.clear();
        this.outputInventory.clear();
        PiglinData.convertInventory(compound.getCompound("InputInventory"), this.inputInventory, provider);
        PiglinData.convertInventory(compound.getCompound("OutputInventory"), this.outputInventory, provider);
        super.loadAdditional(compound, provider);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((BartererTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((BartererTileentity)this).setChanged());
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

