/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.easypiglins.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easypiglins.corelib.client.ItemRenderer;
import de.maxhenkel.easypiglins.corelib.client.RendererProviders;
import de.maxhenkel.easypiglins.datacomponents.PiglinBlockEntityData;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BlockItemRendererBase<T extends BlockEntityRenderer<U>, U extends FakeWorldTileentity>
extends ItemRenderer {
    private Function<BlockEntityRendererProvider.Context, T> rendererSupplier;
    private Supplier<U> tileEntitySupplier;
    private T renderer;
    private Minecraft minecraft;

    public BlockItemRendererBase(Function<BlockEntityRendererProvider.Context, T> rendererSupplier, Supplier<U> tileentitySupplier) {
        this.rendererSupplier = rendererSupplier;
        this.tileEntitySupplier = tileentitySupplier;
        this.minecraft = Minecraft.getInstance();
    }

    @Override
    public void renderByItem(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (this.renderer == null) {
            this.renderer = (BlockEntityRenderer)this.rendererSupplier.apply(RendererProviders.createBlockEntityRendererContext());
        }
        U blockEntity = PiglinBlockEntityData.getAndStoreBlockEntity(itemStack, (HolderLookup.Provider)this.minecraft.level.registryAccess(), (Level)this.minecraft.level, this.tileEntitySupplier);
        this.renderer.render(blockEntity, 0.0f, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

