/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.crusher;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.ChanceOutput;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.content.stages.IXyStage;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record CrusherRecipe(SizedIngredient input, ArrayList<ChanceOutput> results, long ticks, Optional<IStage> requiredStage) implements IRecipeContent<Input, CrusherRecipe>,
IRecipeWithStage
{
    private static final MapCodec<CrusherRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedIngredient.FLAT_CODEC.fieldOf("ingredient").forGetter(CrusherRecipe::input), (App)ChanceOutput.CODEC.listOf().xmap(ArrayList::new, ArrayList::new).fieldOf("results").forGetter(CrusherRecipe::results), (App)Codec.LONG.fieldOf("ticks").forGetter(CrusherRecipe::ticks), (App)IXyStage.CODEC.optionalFieldOf("stage_required").forGetter(CrusherRecipe::requiredStage)).apply((Applicative)builder, CrusherRecipe::new));
    private static final BinarySerializer<CrusherRecipe> SerDes = BinarySerializer.ofType(CrusherRecipe::new, CrusherRecipe::input, (BinarySerializer)Serializer.SIZED_INGREDIENT, CrusherRecipe::results, (BinarySerializer)BinarySerializer.ofCollection(ArrayList::new, (BinarySerializer)ChanceOutput.SerDes), CrusherRecipe::ticks, (BinarySerializer)Serializer.LONG, CrusherRecipe::requiredStage, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IXyStage.SerDes));

    public CrusherRecipe {
        if (results.size() > 9) {
            throw new IllegalArgumentException("Too many ingredients in crusher recipe");
        }
    }

    public Optional<IStage> getRequiredStage() {
        return this.requiredStage();
    }

    public static RecipeSerDes<CrusherRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<CrusherRecipe> getContent() {
        return MachinesRecipeTypes.Crusher;
    }

    public boolean matches(@NotNull Input input, @NotNull Level level) {
        return this.input.test(input.getInputItem());
    }

    public NonNullList<ItemStack> getFinalizedResults(RandomSource randomSource) {
        NonNullList list = NonNullList.create();
        for (ChanceOutput chanceOutput : this.results()) {
            if (chanceOutput.chance() < randomSource.nextIntBetweenInclusive(0, 100)) continue;
            list.add((Object)chanceOutput.output());
        }
        return list;
    }

    public static interface Input
    extends IRecipeContainer {
        public ItemStack getInputItem();
    }
}

